/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class InstanceMonitor
extends DynamicMBeanProvider {
    private final String _clusterName;
    private final String _participantName;
    private final ObjectName _initObjectName;
    private List<String> _tags;
    private SimpleDynamicMetric<Long> _totalMessagedReceivedCounter;
    private SimpleDynamicMetric<Long> _enabledStatusGauge;
    private SimpleDynamicMetric<Long> _disabledPartitionsGauge;
    private SimpleDynamicMetric<Long> _allPartitionsDisabledGauge;
    private SimpleDynamicMetric<Long> _onlineStatusGauge;
    private SimpleDynamicMetric<Double> _maxCapacityUsageGauge;
    private SimpleDynamicMetric<Long> _messageQueueSizeGauge;
    private SimpleDynamicMetric<Long> _pastDueMessageGauge;
    private final Map<String, SimpleDynamicMetric<Long>> _dynamicCapacityMetricsMap;

    public InstanceMonitor(String clusterName, String participantName, ObjectName objectName) {
        this._clusterName = clusterName;
        this._participantName = participantName;
        this._tags = ImmutableList.of((Object)"DEFAULT");
        this._initObjectName = objectName;
        this._dynamicCapacityMetricsMap = new ConcurrentHashMap<String, SimpleDynamicMetric<Long>>();
        this.createMetrics();
    }

    private void createMetrics() {
        this._totalMessagedReceivedCounter = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.TOTAL_MESSAGE_RECEIVED_COUNTER.metricName(), 0L);
        this._disabledPartitionsGauge = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.DISABLED_PARTITIONS_GAUGE.metricName(), 0L);
        this._allPartitionsDisabledGauge = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.ALL_PARTITIONS_DISABLED_GAUGE.metricName(), 0L);
        this._enabledStatusGauge = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.ENABLED_STATUS_GAUGE.metricName(), 0L);
        this._onlineStatusGauge = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.ONLINE_STATUS_GAUGE.metricName(), 0L);
        this._maxCapacityUsageGauge = new SimpleDynamicMetric<Double>(InstanceMonitorMetric.MAX_CAPACITY_USAGE_GAUGE.metricName(), 0.0);
        this._messageQueueSizeGauge = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.MESSAGE_QUEUE_SIZE_GAUGE.metricName(), 0L);
        this._pastDueMessageGauge = new SimpleDynamicMetric<Long>(InstanceMonitorMetric.PASTDUE_MESSAGE_GAUGE.metricName(), 0L);
    }

    private List<DynamicMetric<?, ?>> buildAttributeList() {
        ArrayList attributeList = Lists.newArrayList((Object[])new DynamicMetric[]{this._totalMessagedReceivedCounter, this._disabledPartitionsGauge, this._allPartitionsDisabledGauge, this._enabledStatusGauge, this._onlineStatusGauge, this._maxCapacityUsageGauge, this._messageQueueSizeGauge, this._pastDueMessageGauge});
        attributeList.addAll(this._dynamicCapacityMetricsMap.values());
        return attributeList;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s.%s", "ParticipantStatus", this._clusterName, this.serializedTags(), this._participantName);
    }

    protected long getOnline() {
        return this._onlineStatusGauge.getValue();
    }

    protected long getEnabled() {
        return this._enabledStatusGauge.getValue();
    }

    protected long getTotalMessageReceived() {
        return this._totalMessagedReceivedCounter.getValue();
    }

    protected long getDisabledPartitions() {
        return this._disabledPartitionsGauge.getValue();
    }

    protected long getAllPartitionsDisabled() {
        return this._allPartitionsDisabledGauge.getValue();
    }

    protected long getMessageQueueSizeGauge() {
        return this._messageQueueSizeGauge.getValue();
    }

    protected long getPastDueMessageGauge() {
        return this._pastDueMessageGauge.getValue();
    }

    protected String getInstanceName() {
        return this._participantName;
    }

    private String serializedTags() {
        return Joiner.on((char)'|').skipNulls().join(this._tags);
    }

    public synchronized void updateInstance(Set<String> tags, Map<String, List<String>> disabledPartitions, List<String> oldDisabledPartitions, boolean isLive, boolean isEnabled) {
        if (tags == null || tags.isEmpty()) {
            this._tags = ImmutableList.of((Object)"DEFAULT");
        } else {
            this._tags = Lists.newArrayList(tags);
            Collections.sort(this._tags);
        }
        long numDisabledPartitions = 0L;
        boolean allPartitionsDisabled = false;
        if (disabledPartitions != null) {
            for (List<String> partitions : disabledPartitions.values()) {
                if (partitions == null) continue;
                numDisabledPartitions += (long)partitions.size();
                if (!partitions.contains("ALL_RESOURCES")) continue;
                allPartitionsDisabled = true;
                --numDisabledPartitions;
            }
        }
        if (oldDisabledPartitions != null) {
            numDisabledPartitions += (long)oldDisabledPartitions.size();
        }
        this._onlineStatusGauge.updateValue(isLive ? 1L : 0L);
        this._enabledStatusGauge.updateValue(isEnabled ? 1L : 0L);
        this._disabledPartitionsGauge.updateValue(numDisabledPartitions);
        this._allPartitionsDisabledGauge.updateValue(allPartitionsDisabled ? 1L : 0L);
    }

    public synchronized void increaseMessageCount(long messageReceived) {
        this._totalMessagedReceivedCounter.updateValue(this._totalMessagedReceivedCounter.getValue() + messageReceived);
    }

    public synchronized void updateMaxCapacityUsage(double maxUsage) {
        this._maxCapacityUsageGauge.updateValue(maxUsage);
    }

    public synchronized void updateMessageQueueSize(long queueSize) {
        this._messageQueueSizeGauge.updateValue(queueSize);
    }

    public synchronized void updatePastDueMessageGauge(long msgCount) {
        this._pastDueMessageGauge.updateValue(msgCount);
    }

    protected synchronized double getMaxCapacityUsageGauge() {
        return this._maxCapacityUsageGauge.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCapacity(Map<String, Integer> capacity) {
        Map<String, SimpleDynamicMetric<Long>> map = this._dynamicCapacityMetricsMap;
        synchronized (map) {
            if (this._dynamicCapacityMetricsMap.keySet().equals(capacity.keySet())) {
                for (Map.Entry<String, Integer> entry : capacity.entrySet()) {
                    this._dynamicCapacityMetricsMap.get(entry.getKey()).updateValue((long)entry.getValue());
                }
                return;
            }
            this._dynamicCapacityMetricsMap.keySet().retainAll(capacity.keySet());
            for (Map.Entry<String, Integer> entry : capacity.entrySet()) {
                String capacityName = entry.getKey();
                if (this._dynamicCapacityMetricsMap.containsKey(capacityName)) {
                    this._dynamicCapacityMetricsMap.get(capacityName).updateValue((long)entry.getValue());
                    continue;
                }
                this._dynamicCapacityMetricsMap.put(capacityName, new SimpleDynamicMetric<Long>(capacityName + "Gauge", Long.valueOf(entry.getValue().intValue())));
            }
        }
        this.updateAttributesInfo(this.buildAttributeList(), "Instance monitor for instance: " + this.getInstanceName());
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        this.doRegister(this.buildAttributeList(), this._initObjectName);
        return this;
    }

    public static enum InstanceMonitorMetric {
        TOTAL_MESSAGE_RECEIVED_COUNTER("TotalMessageReceived"),
        ENABLED_STATUS_GAUGE("Enabled"),
        ONLINE_STATUS_GAUGE("Online"),
        DISABLED_PARTITIONS_GAUGE("DisabledPartitions"),
        ALL_PARTITIONS_DISABLED_GAUGE("AllPartitionsDisabled"),
        MAX_CAPACITY_USAGE_GAUGE("MaxCapacityUsageGauge"),
        MESSAGE_QUEUE_SIZE_GAUGE("MessageQueueSizeGauge"),
        PASTDUE_MESSAGE_GAUGE("PastDueMessageGauge");

        private final String metricName;

        private InstanceMonitorMetric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }
    }
}

