/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.util.WagedRebalanceUtil;
import org.apache.helix.controller.rebalancer.waged.AssignmentManager;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModelProvider;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.metrics.MetricCollector;
import org.apache.helix.monitoring.metrics.WagedRebalancerMetricCollector;
import org.apache.helix.monitoring.metrics.implementation.BaselineDivergenceGauge;
import org.apache.helix.monitoring.metrics.model.CountMetric;
import org.apache.helix.monitoring.metrics.model.LatencyMetric;
import org.apache.helix.util.RebalanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartialRebalanceRunner
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PartialRebalanceRunner.class);
    private final ExecutorService _bestPossibleCalculateExecutor;
    private final AssignmentManager _assignmentManager;
    private final AssignmentMetadataStore _assignmentMetadataStore;
    private final BaselineDivergenceGauge _baselineDivergenceGauge;
    private final CountMetric _rebalanceFailureCount;
    private final CountMetric _partialRebalanceCounter;
    private final LatencyMetric _partialRebalanceLatency;
    private boolean _asyncPartialRebalanceEnabled;
    private Future<Boolean> _asyncPartialRebalanceResult;

    public PartialRebalanceRunner(AssignmentManager assignmentManager, AssignmentMetadataStore assignmentMetadataStore, MetricCollector metricCollector, CountMetric rebalanceFailureCount, boolean isAsyncPartialRebalanceEnabled) {
        this._assignmentManager = assignmentManager;
        this._assignmentMetadataStore = assignmentMetadataStore;
        this._bestPossibleCalculateExecutor = Executors.newSingleThreadExecutor();
        this._rebalanceFailureCount = rebalanceFailureCount;
        this._asyncPartialRebalanceEnabled = isAsyncPartialRebalanceEnabled;
        this._partialRebalanceCounter = metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.PartialRebalanceCounter.name(), CountMetric.class);
        this._partialRebalanceLatency = metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.PartialRebalanceLatencyGauge.name(), LatencyMetric.class);
        this._baselineDivergenceGauge = metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.BaselineDivergenceGauge.name(), BaselineDivergenceGauge.class);
    }

    public void partialRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        if (this._asyncPartialRebalanceEnabled && this._asyncPartialRebalanceResult != null && !this._asyncPartialRebalanceResult.isDone()) {
            return;
        }
        this._asyncPartialRebalanceResult = this._bestPossibleCalculateExecutor.submit(() -> {
            try {
                this.doPartialRebalance(clusterData, resourceMap, activeNodes, algorithm, currentStateOutput);
            }
            catch (HelixRebalanceException e) {
                if (this._asyncPartialRebalanceEnabled) {
                    this._rebalanceFailureCount.increment(1L);
                }
                LOG.error("Failed to calculate best possible assignment!", (Throwable)e);
                return false;
            }
            return true;
        });
        if (!this._asyncPartialRebalanceEnabled) {
            try {
                if (!this._asyncPartialRebalanceResult.get().booleanValue()) {
                    throw new HelixRebalanceException("Failed to calculate for the new best possible.", HelixRebalanceException.Type.FAILED_TO_CALCULATE);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HelixRebalanceException("Failed to execute new best possible calculation.", HelixRebalanceException.Type.FAILED_TO_CALCULATE, e);
            }
        }
    }

    private void doPartialRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, RebalanceAlgorithm algorithm, CurrentStateOutput currentStateOutput) throws HelixRebalanceException {
        ClusterModel clusterModel;
        LOG.info("Start calculating the new best possible assignment.");
        this._partialRebalanceCounter.increment(1L);
        this._partialRebalanceLatency.startMeasuringLatency();
        int newBestPossibleAssignmentVersion = -1;
        if (this._assignmentMetadataStore != null) {
            newBestPossibleAssignmentVersion = this._assignmentMetadataStore.getBestPossibleVersion() + 1;
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip getting best possible assignment version.");
        }
        Map<String, ResourceAssignment> currentBaseline = this._assignmentManager.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        Map<String, ResourceAssignment> currentBestPossibleAssignment = this._assignmentManager.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        try {
            clusterModel = ClusterModelProvider.generateClusterModelForPartialRebalance(clusterData, resourceMap, activeNodes, currentBaseline, currentBestPossibleAssignment);
        }
        catch (Exception ex) {
            throw new HelixRebalanceException("Failed to generate cluster model for partial rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
        }
        Map<String, ResourceAssignment> newAssignment = WagedRebalanceUtil.calculateAssignment(clusterModel, algorithm);
        HashMap<String, ResourceAssignment> newAssignmentCopy = new HashMap<String, ResourceAssignment>();
        for (Map.Entry<String, ResourceAssignment> entry : newAssignment.entrySet()) {
            newAssignmentCopy.put(entry.getKey(), new ResourceAssignment(entry.getValue().getRecord()));
        }
        this._baselineDivergenceGauge.asyncMeasureAndUpdateValue(clusterData.getAsyncTasksThreadPool(), currentBaseline, newAssignmentCopy);
        boolean bestPossibleUpdateSuccessful = false;
        if (this._assignmentMetadataStore != null && this._assignmentMetadataStore.isBestPossibleChanged(newAssignment)) {
            bestPossibleUpdateSuccessful = this._assignmentMetadataStore.asyncUpdateBestPossibleAssignmentCache(newAssignment, newBestPossibleAssignmentVersion);
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the baseline assignment.");
        }
        this._partialRebalanceLatency.endMeasuringLatency();
        LOG.info("Finish calculating the new best possible assignment.");
        if (bestPossibleUpdateSuccessful) {
            LOG.info("Schedule a new rebalance after the new best possible calculation has finished.");
            RebalanceUtil.scheduleOnDemandPipeline(clusterData.getClusterName(), 0L, false);
        }
    }

    public void setPartialRebalanceAsyncMode(boolean isAsyncPartialRebalanceEnabled) {
        this._asyncPartialRebalanceEnabled = isAsyncPartialRebalanceEnabled;
    }

    public boolean isAsyncPartialRebalanceEnabled() {
        return this._asyncPartialRebalanceEnabled;
    }

    @Override
    public void close() {
        if (this._bestPossibleCalculateExecutor != null) {
            this._bestPossibleCalculateExecutor.shutdownNow();
        }
    }
}

