/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.store;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.helix.HelixException;
import org.apache.helix.store.PropertySerializer;
import org.apache.helix.store.PropertyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyJsonSerializer<T>
implements PropertySerializer<T> {
    private static Logger LOG = LoggerFactory.getLogger(PropertyJsonSerializer.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private final Class<T> _clazz;

    public PropertyJsonSerializer(Class<T> clazz) {
        this._clazz = clazz;
    }

    @Override
    public byte[] serialize(T data) throws PropertyStoreException {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        mapper.enable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, data);
            if (sw.toString().getBytes().length > 1024000) {
                throw new HelixException("Data size larger than 1M. Write empty string to zk.");
            }
            return sw.toString().getBytes();
        }
        catch (Exception e) {
            LOG.error("Error during serialization of data (first 1k): " + sw.toString().substring(0, 1024), (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public T deserialize(byte[] bytes) throws PropertyStoreException {
        mapper.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
        mapper.configure(MapperFeature.AUTO_DETECT_SETTERS, true);
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            Object value = mapper.readValue((InputStream)bais, this._clazz);
            return (T)value;
        }
        catch (Exception e) {
            LOG.error("Error during deserialization of bytes: " + new String(bytes), (Throwable)e);
            return null;
        }
    }
}

