/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.controller.changedetector.trimmer.ClusterConfigTrimmer;
import org.apache.helix.controller.changedetector.trimmer.IdealStateTrimmer;
import org.apache.helix.controller.changedetector.trimmer.InstanceConfigTrimmer;
import org.apache.helix.controller.changedetector.trimmer.ResourceConfigTrimmer;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.ResourceConfig;

class ResourceChangeSnapshot {
    private Set<HelixConstants.ChangeType> _changedTypes;
    private Map<String, InstanceConfig> _allInstanceConfigMap;
    private Map<String, InstanceConfig> _assignableInstanceConfigMap;
    private Map<String, IdealState> _idealStateMap;
    private Map<String, ResourceConfig> _resourceConfigMap;
    private Map<String, LiveInstance> _allLiveInstances;
    private Map<String, LiveInstance> _assignableLiveInstances;
    private ClusterConfig _clusterConfig;

    ResourceChangeSnapshot() {
        this._changedTypes = new HashSet<HelixConstants.ChangeType>();
        this._allInstanceConfigMap = new HashMap<String, InstanceConfig>();
        this._assignableInstanceConfigMap = new HashMap<String, InstanceConfig>();
        this._idealStateMap = new HashMap<String, IdealState>();
        this._resourceConfigMap = new HashMap<String, ResourceConfig>();
        this._allLiveInstances = new HashMap<String, LiveInstance>();
        this._assignableLiveInstances = new HashMap<String, LiveInstance>();
        this._clusterConfig = null;
    }

    ResourceChangeSnapshot(ResourceControllerDataProvider dataProvider, boolean ignoreNonTopologyChange) {
        this._changedTypes = new HashSet<HelixConstants.ChangeType>(dataProvider.getRefreshedChangeTypes());
        this._allInstanceConfigMap = ignoreNonTopologyChange ? dataProvider.getInstanceConfigMap().entrySet().parallelStream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> InstanceConfigTrimmer.getInstance().trimProperty((InstanceConfig)e.getValue()))) : new HashMap<String, InstanceConfig>(dataProvider.getInstanceConfigMap());
        this._assignableInstanceConfigMap = ignoreNonTopologyChange ? dataProvider.getAssignableInstanceConfigMap().entrySet().parallelStream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> InstanceConfigTrimmer.getInstance().trimProperty((InstanceConfig)e.getValue()))) : new HashMap<String, InstanceConfig>(dataProvider.getAssignableInstanceConfigMap());
        this._idealStateMap = ignoreNonTopologyChange ? dataProvider.getIdealStates().entrySet().parallelStream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> IdealStateTrimmer.getInstance().trimProperty((IdealState)e.getValue()))) : new HashMap<String, IdealState>(dataProvider.getIdealStates());
        this._resourceConfigMap = ignoreNonTopologyChange ? dataProvider.getResourceConfigMap().entrySet().parallelStream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ResourceConfigTrimmer.getInstance().trimProperty((ResourceConfig)e.getValue()))) : new HashMap<String, ResourceConfig>(dataProvider.getResourceConfigMap());
        this._clusterConfig = ignoreNonTopologyChange ? ClusterConfigTrimmer.getInstance().trimProperty(dataProvider.getClusterConfig()) : dataProvider.getClusterConfig();
        this._allLiveInstances = new HashMap<String, LiveInstance>(dataProvider.getLiveInstances());
        this._assignableLiveInstances = new HashMap<String, LiveInstance>(dataProvider.getAssignableLiveInstances());
    }

    ResourceChangeSnapshot(ResourceChangeSnapshot snapshot) {
        this._changedTypes = new HashSet<HelixConstants.ChangeType>(snapshot._changedTypes);
        this._allInstanceConfigMap = new HashMap<String, InstanceConfig>(snapshot._allInstanceConfigMap);
        this._assignableInstanceConfigMap = new HashMap<String, InstanceConfig>(snapshot._assignableInstanceConfigMap);
        this._idealStateMap = new HashMap<String, IdealState>(snapshot._idealStateMap);
        this._resourceConfigMap = new HashMap<String, ResourceConfig>(snapshot._resourceConfigMap);
        this._allLiveInstances = new HashMap<String, LiveInstance>(snapshot._allLiveInstances);
        this._assignableLiveInstances = new HashMap<String, LiveInstance>(snapshot._assignableLiveInstances);
        this._clusterConfig = snapshot._clusterConfig;
    }

    Set<HelixConstants.ChangeType> getChangedTypes() {
        return this._changedTypes;
    }

    Map<String, InstanceConfig> getInstanceConfigMap() {
        return this._allInstanceConfigMap;
    }

    Map<String, InstanceConfig> getAssignableInstanceConfigMap() {
        return this._assignableInstanceConfigMap;
    }

    Map<String, IdealState> getIdealStateMap() {
        return this._idealStateMap;
    }

    Map<String, ResourceConfig> getResourceConfigMap() {
        return this._resourceConfigMap;
    }

    Map<String, LiveInstance> getLiveInstances() {
        return this._allLiveInstances;
    }

    Map<String, LiveInstance> getAssignableLiveInstances() {
        return this._assignableLiveInstances;
    }

    ClusterConfig getClusterConfig() {
        return this._clusterConfig;
    }
}

