/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.examples.LeaderStandbyStateModelFactory;
import org.apache.helix.examples.MasterSlaveStateModelFactory;
import org.apache.helix.examples.OnlineOfflineStateModelFactory;
import org.apache.helix.manager.zk.HelixManagerShutdownHook;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleProcess {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleProcess.class);
    public static final String zkServer = "zkSvr";
    public static final String cluster = "cluster";
    public static final String hostAddress = "host";
    public static final String hostPort = "port";
    public static final String relayCluster = "relayCluster";
    public static final String help = "help";
    public static final String configFile = "configFile";
    public static final String stateModel = "stateModelType";
    public static final String transDelay = "transDelay";
    private final String zkConnectString;
    private final String clusterName;
    private final String instanceName;
    private final String stateModelType;
    private HelixManager manager;
    private StateModelFactory<StateModel> stateModelFactory;
    private final int delay;

    public ExampleProcess(String zkConnectString, String clusterName, String instanceName, String file, String stateModel, int delay) {
        this.zkConnectString = zkConnectString;
        this.clusterName = clusterName;
        this.instanceName = instanceName;
        this.stateModelType = stateModel;
        this.delay = delay;
    }

    public void start() throws Exception {
        this.manager = HelixManagerFactory.getZKHelixManager(this.clusterName, this.instanceName, InstanceType.PARTICIPANT, this.zkConnectString);
        if ("MasterSlave".equalsIgnoreCase(this.stateModelType)) {
            this.stateModelFactory = new MasterSlaveStateModelFactory(this.instanceName, this.delay);
        } else if ("OnlineOffline".equalsIgnoreCase(this.stateModelType)) {
            this.stateModelFactory = new OnlineOfflineStateModelFactory(this.instanceName, this.delay);
        } else if ("LeaderStandby".equalsIgnoreCase(this.stateModelType)) {
            this.stateModelFactory = new LeaderStandbyStateModelFactory(this.instanceName, this.delay);
        }
        StateMachineEngine stateMach = this.manager.getStateMachineEngine();
        stateMach.registerStateModelFactory(this.stateModelType, this.stateModelFactory);
        this.manager.connect();
        this.manager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.STATE_TRANSITION.name(), (MessageHandlerFactory)stateMach);
    }

    public void stop() {
        this.manager.disconnect();
    }

    public HelixManager getManager() {
        return this.manager;
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServer);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name (Required)");
        OptionBuilder.withLongOpt((String)hostAddress);
        OptionBuilder.withDescription((String)"Provide host name");
        Option hostOption = OptionBuilder.create();
        hostOption.setArgs(1);
        hostOption.setRequired(true);
        hostOption.setArgName("Host name (Required)");
        OptionBuilder.withLongOpt((String)hostPort);
        OptionBuilder.withDescription((String)"Provide host port");
        Option portOption = OptionBuilder.create();
        portOption.setArgs(1);
        portOption.setRequired(true);
        portOption.setArgName("Host port (Required)");
        OptionBuilder.withLongOpt((String)stateModel);
        OptionBuilder.withDescription((String)"StateModel Type");
        Option stateModelOption = OptionBuilder.create();
        stateModelOption.setArgs(1);
        stateModelOption.setRequired(true);
        stateModelOption.setArgName("StateModel Type (Required)");
        OptionBuilder.withLongOpt((String)configFile);
        OptionBuilder.withDescription((String)"Provide file to read states/messages");
        Option fileOption = OptionBuilder.create();
        fileOption.setArgs(1);
        fileOption.setRequired(true);
        fileOption.setArgName("File to read states/messages (Optional)");
        OptionBuilder.withLongOpt((String)transDelay);
        OptionBuilder.withDescription((String)"Provide state trans delay");
        Option transDelayOption = OptionBuilder.create();
        transDelayOption.setArgs(1);
        transDelayOption.setRequired(false);
        transDelayOption.setArgName("Delay time in state transition, in MS");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(zkServerOption);
        optionGroup.addOption(fileOption);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(clusterOption);
        options.addOption(hostOption);
        options.addOption(portOption);
        options.addOption(stateModelOption);
        options.addOption(transDelayOption);
        options.addOptionGroup(optionGroup);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ExampleProcess.class.getName(), cliOptions);
    }

    public static CommandLine processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = ExampleProcess.constructCommandLineOptions();
        try {
            return cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe.toString());
            ExampleProcess.printUsage(cliOptions);
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String zkConnectString = "localhost:2181";
        String clusterName = "storage-integration-cluster";
        String instanceName = "localhost_8905";
        String file = null;
        String stateModelValue = "MasterSlave";
        int delay = 0;
        boolean skipZeroArgs = true;
        if (!skipZeroArgs || args.length > 0) {
            File f;
            CommandLine cmd = ExampleProcess.processCommandLineArgs(args);
            zkConnectString = cmd.getOptionValue(zkServer);
            clusterName = cmd.getOptionValue(cluster);
            String host = cmd.getOptionValue(hostAddress);
            String portString = cmd.getOptionValue(hostPort);
            int port = Integer.parseInt(portString);
            instanceName = host + "_" + port;
            file = cmd.getOptionValue(configFile);
            if (file != null && !(f = new File(file)).exists()) {
                System.err.println("static config file doesn't exist");
                System.exit(1);
            }
            stateModelValue = cmd.getOptionValue(stateModel);
            if (cmd.hasOption(transDelay)) {
                try {
                    delay = Integer.parseInt(cmd.getOptionValue(transDelay));
                    if (delay < 0) {
                        throw new Exception("delay must be positive");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    delay = 0;
                }
            }
        }
        System.out.println("Starting Process with ZK:" + zkConnectString);
        ExampleProcess process = new ExampleProcess(zkConnectString, clusterName, instanceName, file, stateModelValue, delay);
        process.start();
        Runtime.getRuntime().addShutdownHook(new HelixManagerShutdownHook(process.getManager()));
        Thread.currentThread().join();
    }
}

