/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ControllerHistory;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.rest.server.service.ClusterServiceImpl;
import org.apache.helix.tools.ClusterSetup;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters")
public class ClusterAccessor
extends AbstractHelixResource {
    private static Logger _logger = LoggerFactory.getLogger((String)ClusterAccessor.class.getName());

    @GET
    public Response getClusters() {
        HelixAdmin helixAdmin = this.getHelixAdmin();
        List clusters = helixAdmin.getClusters();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        dataMap.put(ClusterProperties.clusters.name(), clusters);
        return this.JSONRepresentation(dataMap);
    }

    @GET
    @Path(value="{clusterId}")
    public Response getClusterInfo(@PathParam(value="clusterId") String clusterId) {
        if (!this.doesClusterExist(clusterId)) {
            return this.notFound();
        }
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        HashMap<String, Object> clusterInfo = new HashMap<String, Object>();
        clusterInfo.put(AbstractResource.Properties.id.name(), clusterId);
        LiveInstance controller = (LiveInstance)dataAccessor.getProperty(keyBuilder.controllerLeader());
        if (controller != null) {
            clusterInfo.put(ClusterProperties.controller.name(), controller.getInstanceName());
        } else {
            clusterInfo.put(ClusterProperties.controller.name(), "No Lead Controller!");
        }
        boolean paused = dataAccessor.getBaseDataAccessor().exists(keyBuilder.pause().getPath(), AccessOption.PERSISTENT);
        clusterInfo.put(ClusterProperties.paused.name(), paused);
        boolean maintenance = this.getHelixAdmin().isInMaintenanceMode(clusterId);
        clusterInfo.put(ClusterProperties.maintenance.name(), maintenance);
        List idealStates = dataAccessor.getChildNames(keyBuilder.idealStates());
        clusterInfo.put(ClusterProperties.resources.name(), idealStates);
        List instances = dataAccessor.getChildNames(keyBuilder.instanceConfigs());
        clusterInfo.put(ClusterProperties.instances.name(), instances);
        List liveInstances = dataAccessor.getChildNames(keyBuilder.liveInstances());
        clusterInfo.put(ClusterProperties.liveInstances.name(), liveInstances);
        return this.JSONRepresentation(clusterInfo);
    }

    @PUT
    @Path(value="{clusterId}")
    public Response createCluster(@PathParam(value="clusterId") String clusterId, @DefaultValue(value="false") @QueryParam(value="recreate") String recreate) {
        boolean recreateIfExists = Boolean.valueOf(recreate);
        ClusterSetup clusterSetup = this.getClusterSetup();
        try {
            clusterSetup.addCluster(clusterId, recreateIfExists);
        }
        catch (Exception ex) {
            _logger.error("Failed to create cluster " + clusterId + ", exception: " + ex);
            return this.serverError(ex);
        }
        return this.created();
    }

    @DELETE
    @Path(value="{clusterId}")
    public Response deleteCluster(@PathParam(value="clusterId") String clusterId) {
        ClusterSetup clusterSetup = this.getClusterSetup();
        try {
            clusterSetup.deleteCluster(clusterId);
        }
        catch (HelixException ex) {
            _logger.info("Failed to delete cluster " + clusterId + ", cluster is still in use. Exception: " + (Object)((Object)ex));
            return this.badRequest(ex.getMessage());
        }
        catch (Exception ex) {
            _logger.error("Failed to delete cluster " + clusterId + ", exception: " + ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @POST
    @Path(value="{clusterId}")
    public Response updateCluster(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, @QueryParam(value="superCluster") String superCluster, String content) {
        AbstractResource.Command command;
        try {
            command = this.getCommand(commandStr);
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        ClusterSetup clusterSetup = this.getClusterSetup();
        HelixAdmin helixAdmin = this.getHelixAdmin();
        switch (command) {
            case activate: {
                if (superCluster == null) {
                    return this.badRequest("Super Cluster name is missing!");
                }
                try {
                    clusterSetup.activateCluster(clusterId, superCluster, true);
                    break;
                }
                catch (Exception ex) {
                    _logger.error("Failed to add cluster " + clusterId + " to super cluster " + superCluster);
                    return this.serverError(ex);
                }
            }
            case expand: {
                try {
                    clusterSetup.expandCluster(clusterId);
                    break;
                }
                catch (Exception ex) {
                    _logger.error("Failed to expand cluster " + clusterId);
                    return this.serverError(ex);
                }
            }
            case enable: {
                try {
                    helixAdmin.enableCluster(clusterId, true);
                    break;
                }
                catch (Exception ex) {
                    _logger.error("Failed to enable cluster " + clusterId);
                    return this.serverError(ex);
                }
            }
            case disable: {
                try {
                    helixAdmin.enableCluster(clusterId, false);
                    break;
                }
                catch (Exception ex) {
                    _logger.error("Failed to disable cluster " + clusterId);
                    return this.serverError(ex);
                }
            }
            case enableMaintenanceMode: 
            case disableMaintenanceMode: {
                Map customFieldsMap = null;
                try {
                    customFieldsMap = (Map)OBJECT_MAPPER.readValue(content, (TypeReference)new TypeReference<HashMap<String, String>>(){});
                    content = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                helixAdmin.manuallyEnableMaintenanceMode(clusterId, command == AbstractResource.Command.enableMaintenanceMode, content, customFieldsMap);
                break;
            }
            default: {
                return this.badRequest("Unsupported command " + (Object)((Object)command));
            }
        }
        return this.OK();
    }

    @GET
    @Path(value="{clusterId}/configs")
    public Response getClusterConfig(@PathParam(value="clusterId") String clusterId) {
        ConfigAccessor accessor = this.getConfigAccessor();
        ClusterConfig config = null;
        try {
            config = accessor.getClusterConfig(clusterId);
        }
        catch (HelixException ex) {
            _logger.info("Failed to get cluster config for cluster " + clusterId + ", cluster not found, Exception: " + (Object)((Object)ex));
        }
        catch (Exception ex) {
            _logger.error("Failed to get cluster config for cluster " + clusterId + " Exception: " + ex);
            return this.serverError(ex);
        }
        if (config == null) {
            return this.notFound();
        }
        return this.JSONRepresentation(config.getRecord());
    }

    @GET
    @Path(value="{clusterId}/topology")
    public Response getClusterTopology(@PathParam(value="clusterId") String clusterId) throws IOException {
        ClusterServiceImpl clusterService = new ClusterServiceImpl(this.getDataAccssor(clusterId), this.getConfigAccessor());
        ObjectMapper objectMapper = new ObjectMapper();
        ClusterTopology clusterTopology = clusterService.getClusterTopology(clusterId);
        return this.OK(objectMapper.writeValueAsString((Object)clusterTopology));
    }

    @POST
    @Path(value="{clusterId}/configs")
    public Response updateClusterConfig(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String commandStr, String content) {
        ZNRecord record;
        AbstractResource.Command command;
        try {
            command = this.getCommand(commandStr);
        }
        catch (HelixException ex) {
            return this.badRequest(ex.getMessage());
        }
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            _logger.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        if (!record.getId().equals(clusterId)) {
            return this.badRequest("ID does not match the cluster name in input!");
        }
        ClusterConfig config = new ClusterConfig(record);
        ConfigAccessor configAccessor = this.getConfigAccessor();
        try {
            switch (command) {
                case update: {
                    configAccessor.updateClusterConfig(clusterId, config);
                    break;
                }
                case delete: {
                    HelixConfigScope clusterScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(clusterId).build();
                    configAccessor.remove(clusterScope, config.getRecord());
                    break;
                }
                default: {
                    return this.badRequest("Unsupported command " + commandStr);
                }
            }
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            _logger.error("Failed to " + (Object)((Object)command) + " cluster config, cluster " + clusterId + " new config: " + content + ", Exception: " + ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @GET
    @Path(value="{clusterId}/controller")
    public Response getClusterController(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        HashMap<String, String> controllerInfo = new HashMap<String, String>();
        controllerInfo.put(AbstractResource.Properties.id.name(), clusterId);
        LiveInstance leader = (LiveInstance)dataAccessor.getProperty(dataAccessor.keyBuilder().controllerLeader());
        if (leader != null) {
            controllerInfo.put(ClusterProperties.controller.name(), leader.getInstanceName());
            controllerInfo.putAll(leader.getRecord().getSimpleFields());
        } else {
            controllerInfo.put(ClusterProperties.controller.name(), "No Lead Controller!");
        }
        return this.JSONRepresentation(controllerInfo);
    }

    @GET
    @Path(value="{clusterId}/controller/history")
    public Response getClusterControllerLeadershipHistory(@PathParam(value="clusterId") String clusterId) {
        return this.JSONRepresentation(this.getControllerHistory(clusterId, ControllerHistory.HistoryType.CONTROLLER_LEADERSHIP));
    }

    @GET
    @Path(value="{clusterId}/controller/maintenanceHistory")
    public Response getClusterMaintenanceHistory(@PathParam(value="clusterId") String clusterId) {
        return this.JSONRepresentation(this.getControllerHistory(clusterId, ControllerHistory.HistoryType.MAINTENANCE));
    }

    @GET
    @Path(value="{clusterId}/controller/maintenanceSignal")
    public Response getClusterMaintenanceSignal(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        MaintenanceSignal maintenanceSignal = (MaintenanceSignal)dataAccessor.getProperty(dataAccessor.keyBuilder().maintenance());
        if (maintenanceSignal != null) {
            Map maintenanceInfo = maintenanceSignal.getRecord().getSimpleFields();
            maintenanceInfo.put(ClusterProperties.clusterName.name(), clusterId);
            return this.JSONRepresentation(maintenanceInfo);
        }
        return this.notFound(String.format("Cluster %s is not in maintenance mode!", clusterId));
    }

    @GET
    @Path(value="{clusterId}/controller/messages")
    public Response getClusterControllerMessages(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        HashMap<String, Object> controllerMessages = new HashMap<String, Object>();
        controllerMessages.put(AbstractResource.Properties.id.name(), clusterId);
        List messages = dataAccessor.getChildNames(dataAccessor.keyBuilder().controllerMessages());
        controllerMessages.put(ClusterProperties.messages.name(), messages);
        controllerMessages.put(AbstractResource.Properties.count.name(), messages.size());
        return this.JSONRepresentation(controllerMessages);
    }

    @GET
    @Path(value="{clusterId}/controller/messages/{messageId}")
    public Response getClusterControllerMessages(@PathParam(value="clusterId") String clusterId, @PathParam(value="messageId") String messageId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        Message message = (Message)dataAccessor.getProperty(dataAccessor.keyBuilder().controllerMessage(messageId));
        return this.JSONRepresentation(message.getRecord());
    }

    @GET
    @Path(value="{clusterId}/statemodeldefs")
    public Response getClusterStateModelDefinitions(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        List stateModelDefs = dataAccessor.getChildNames(dataAccessor.keyBuilder().stateModelDefs());
        HashMap<String, Object> clusterStateModelDefs = new HashMap<String, Object>();
        clusterStateModelDefs.put(AbstractResource.Properties.id.name(), clusterId);
        clusterStateModelDefs.put(ClusterProperties.stateModelDefinitions.name(), stateModelDefs);
        return this.JSONRepresentation(clusterStateModelDefs);
    }

    @GET
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response getClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        StateModelDefinition stateModelDef = (StateModelDefinition)dataAccessor.getProperty(dataAccessor.keyBuilder().stateModelDef(statemodel));
        if (stateModelDef == null) {
            return this.badRequest("Statemodel not found!");
        }
        return this.JSONRepresentation(stateModelDef.getRecord());
    }

    @PUT
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response createClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel, String content) {
        ZNRecord record;
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            _logger.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        HelixZkClient zkClient = this.getHelixZkClient();
        String path = PropertyPathBuilder.stateModelDef((String)clusterId);
        try {
            ZKUtil.createChildren((HelixZkClient)zkClient, (String)path, (ZNRecord)record);
        }
        catch (Exception e) {
            _logger.error("Failed to create zk node with path " + path + ", Exception:" + e);
            return this.badRequest("Failed to create a Znode for stateModel! " + e);
        }
        return this.OK();
    }

    @POST
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response setClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel, String content) {
        ZNRecord record;
        try {
            record = ClusterAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            _logger.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a valid ZNRecord!");
        }
        StateModelDefinition stateModelDefinition = new StateModelDefinition(record);
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        PropertyKey key = dataAccessor.keyBuilder().stateModelDef(stateModelDefinition.getId());
        boolean retcode = true;
        try {
            retcode = dataAccessor.setProperty(key, (HelixProperty)stateModelDefinition);
        }
        catch (Exception e) {
            _logger.error("Failed to set StateModelDefinition key:" + key + ", Exception: " + e);
            return this.badRequest("Failed to set the content " + content);
        }
        return this.OK();
    }

    @DELETE
    @Path(value="{clusterId}/statemodeldefs/{statemodel}")
    public Response removeClusterStateModelDefinition(@PathParam(value="clusterId") String clusterId, @PathParam(value="statemodel") String statemodel) {
        if (!StringUtils.isAlphanumeric((CharSequence)statemodel)) {
            return this.badRequest("Invalid statemodel name!");
        }
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        PropertyKey key = dataAccessor.keyBuilder().stateModelDef(statemodel);
        boolean retcode = true;
        try {
            retcode = dataAccessor.removeProperty(key);
        }
        catch (Exception e) {
            _logger.error("Failed to remove StateModelDefinition key:" + key + ", Exception: " + e);
            retcode = false;
        }
        if (!retcode) {
            return this.badRequest("Failed to remove!");
        }
        return this.OK();
    }

    @GET
    @Path(value="{clusterId}/maintenance")
    public Response getClusterMaintenanceMode(@PathParam(value="clusterId") String clusterId) {
        return this.JSONRepresentation(ImmutableMap.of((Object)ClusterProperties.maintenance.name(), (Object)this.getHelixAdmin().isInMaintenanceMode(clusterId)));
    }

    private boolean doesClusterExist(String cluster) {
        HelixZkClient zkClient = this.getHelixZkClient();
        return ZKUtil.isClusterSetup((String)cluster, (HelixZkClient)zkClient);
    }

    private Map<String, Object> getControllerHistory(String clusterId, ControllerHistory.HistoryType historyType) {
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        HashMap<String, Object> history = new HashMap<String, Object>();
        history.put(AbstractResource.Properties.id.name(), clusterId);
        ControllerHistory historyRecord = (ControllerHistory)dataAccessor.getProperty(dataAccessor.keyBuilder().controllerLeaderHistory());
        switch (historyType) {
            case CONTROLLER_LEADERSHIP: {
                history.put(AbstractResource.Properties.history.name(), historyRecord != null ? historyRecord.getHistoryList() : Collections.emptyList());
                break;
            }
            case MAINTENANCE: {
                history.put(ClusterProperties.maintenanceHistory.name(), historyRecord != null ? historyRecord.getMaintenanceHistoryList() : Collections.emptyList());
            }
        }
        return history;
    }

    public static enum ClusterProperties {
        controller,
        instances,
        liveInstances,
        resources,
        paused,
        maintenance,
        messages,
        stateModelDefinitions,
        clusters,
        maintenanceSignal,
        maintenanceHistory,
        clusterName;

    }
}

