/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.SessionTrackingMode;
import javax.servlet.SingleThreadModel;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpUpgradeHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.util.ClassLoaderUtil;
import org.glassfish.grizzly.http.server.util.DispatcherHelper;
import org.glassfish.grizzly.http.server.util.Enumerator;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.ApplicationDispatcher;
import org.glassfish.grizzly.servlet.DefaultServlet;
import org.glassfish.grizzly.servlet.FilterChainFactory;
import org.glassfish.grizzly.servlet.FilterConfigImpl;
import org.glassfish.grizzly.servlet.FilterMap;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletConfigImpl;
import org.glassfish.grizzly.servlet.ServletHandler;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.SessionCookieConfig;
import org.glassfish.grizzly.utils.ArraySet;
import org.glassfish.grizzly.utils.DataStructures;

public class WebappContext
implements ServletContext {
    private static final Logger LOGGER = Grizzly.logger(WebappContext.class);
    private static final Map<WebappContext, HttpServer> DEPLOYED_APPS = new HashMap<WebappContext, HttpServer>();
    private static final Set<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = EnumSet.of(SessionTrackingMode.COOKIE);
    private static final int MAJOR_VERSION = 3;
    private static final int MINOR_VERSION = 1;
    private final String displayName;
    private final String contextPath;
    private final String basePath;
    private final Map<String, String> contextInitParams = new LinkedHashMap<String, String>(8, 1.0f);
    private final List<String> securityRoles = new ArrayList<String>();
    protected final Map<String, ServletRegistration> servletRegistrations = new HashMap<String, ServletRegistration>(8, 1.0f);
    protected final Map<String, FilterRegistration> filterRegistrations = new LinkedHashMap<String, FilterRegistration>(4, 1.0f);
    protected final Map<String, FilterRegistration> unmodifiableFilterRegistrations = Collections.unmodifiableMap(this.filterRegistrations);
    private Set<ServletHandler> servletHandlers;
    private final Set<EventListener> eventListenerInstances = new LinkedHashSet<EventListener>(4, 1.0f);
    private EventListener[] eventListeners = new EventListener[0];
    protected boolean deployed;
    private final FilterChainFactory filterChainFactory;
    private final ConcurrentMap<String, Object> attributes = DataStructures.getConcurrentMap((int)16, (float)0.75f, (int)64);
    private volatile String serverInfo = "Grizzly " + Grizzly.getDotedVersion();
    private final ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private DispatcherHelper dispatcherHelper;
    private ClassLoader webappClassLoader;
    private javax.servlet.SessionCookieConfig sessionCookieConfig;
    private Set<SessionTrackingMode> sessionTrackingModes;
    private final Runnable onDestroyListener = new Runnable(){

        @Override
        public void run() {
            if (WebappContext.this.deployed) {
                WebappContext.this.undeploy();
            }
        }
    };
    private final List<FilterMap> filterMaps = new ArrayList<FilterMap>();

    protected WebappContext() {
        this.displayName = "";
        this.contextPath = "";
        this.basePath = "";
        this.filterChainFactory = new FilterChainFactory(this);
    }

    public WebappContext(String displayName) {
        this(displayName, "");
    }

    public WebappContext(String displayName, String contextPath) {
        this(displayName, contextPath, ".");
    }

    public WebappContext(String displayName, String contextPath, String basePath) {
        if (displayName == null || displayName.length() == 0) {
            throw new IllegalArgumentException("'displayName' cannot be null or zero-length");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("'contextPath' cannot be null");
        }
        if (contextPath.length() > 0) {
            if (contextPath.charAt(0) != '/') {
                throw new IllegalArgumentException("'contextPath' must start with a forward slash");
            }
            if (!contextPath.equals("/") && contextPath.charAt(contextPath.length() - 1) == '/') {
                throw new IllegalArgumentException("'contextPath' must not end with a forward slash");
            }
        }
        this.displayName = displayName;
        this.contextPath = contextPath;
        try {
            this.basePath = new File(basePath).getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to resolve path: " + basePath);
        }
        this.filterChainFactory = new FilterChainFactory(this);
        Mapper.setAllowReplacement((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy(HttpServer targetServer) {
        if (!this.deployed) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Starting application [{0}] ...", this.displayName);
            }
            boolean error = false;
            try {
                this.webappClassLoader = ClassLoaderUtil.createURLClassLoader((String)new File(this.getBasePath()).getCanonicalPath());
                this.initializeListeners();
                this.contextInitialized();
                this.initServlets(targetServer);
                this.initFilters();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Application [{0}] is ready to service requests.  Root: [{1}].", new Object[]{this.displayName, this.contextPath});
                }
                DEPLOYED_APPS.put(this, targetServer);
                this.deployed = true;
            }
            catch (Exception e) {
                error = true;
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "[" + this.displayName + "] Exception deploying application.  See stack trace for details.", e);
                }
            }
            finally {
                if (error) {
                    this.undeploy();
                }
            }
        }
    }

    public synchronized void undeploy() {
        block3: {
            try {
                if (this.deployed) {
                    this.deployed = false;
                    HttpServer server = DEPLOYED_APPS.remove(this);
                    this.destoryServlets(server);
                    this.destroyFilters();
                    this.contextDestroyed();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, "[" + this.displayName + "] Exception undeploying application.  See stack trace for details.", e);
            }
        }
    }

    public void addContextInitParameter(String name, String value) {
        if (!this.deployed) {
            this.contextInitParams.put(name, value);
        }
    }

    public void removeContextInitParameter(String name) {
        if (!this.deployed) {
            this.contextInitParams.remove(name);
        }
    }

    public void clearContextInitParameters() {
        if (!this.deployed) {
            this.contextInitParams.clear();
        }
    }

    public FilterRegistration addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (filterName == null) {
            throw new IllegalArgumentException("'filterName' cannot be null");
        }
        if (filterClass == null) {
            throw new IllegalArgumentException("'filterClass' cannot be null");
        }
        FilterRegistration registration = this.filterRegistrations.get(filterName);
        if (registration == null) {
            registration = new FilterRegistration(this, filterName, filterClass);
            this.filterRegistrations.put(filterName, registration);
        } else if (registration.filterClass != filterClass) {
            registration.filter = null;
            registration.filterClass = filterClass;
            registration.className = filterClass.getName();
        }
        return registration;
    }

    public FilterRegistration addFilter(String filterName, Filter filter) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (filterName == null) {
            throw new IllegalArgumentException("'filterName' cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("'filter' cannot be null");
        }
        FilterRegistration registration = this.filterRegistrations.get(filterName);
        if (registration == null) {
            registration = new FilterRegistration(this, filterName, filter);
            this.filterRegistrations.put(filterName, registration);
        } else if (registration.filter != filter) {
            registration.filter = filter;
            registration.filterClass = filter.getClass();
            registration.className = filter.getClass().getName();
        }
        return registration;
    }

    public FilterRegistration addFilter(String filterName, String className) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (filterName == null) {
            throw new IllegalArgumentException("'filterName' cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("'className' cannot be null");
        }
        FilterRegistration registration = this.filterRegistrations.get(filterName);
        if (registration == null) {
            registration = new FilterRegistration(this, filterName, className);
            this.filterRegistrations.put(filterName, registration);
        } else if (!registration.className.equals(className)) {
            registration.className = className;
            registration.filterClass = null;
            registration.filter = null;
        }
        return registration;
    }

    public ServletRegistration addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (servletName == null) {
            throw new IllegalArgumentException("'servletName' cannot be null");
        }
        if (servletClass == null) {
            throw new IllegalArgumentException("'servletClass' cannot be null");
        }
        ServletRegistration registration = this.servletRegistrations.get(servletName);
        if (registration == null) {
            registration = new ServletRegistration(this, servletName, servletClass);
            this.servletRegistrations.put(servletName, registration);
        } else if (registration.servletClass != servletClass) {
            registration.servlet = null;
            registration.servletClass = servletClass;
            registration.className = servletClass.getName();
        }
        return registration;
    }

    public ServletRegistration addServlet(String servletName, Servlet servlet) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (servletName == null) {
            throw new IllegalArgumentException("'servletName' cannot be null");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("'servlet' cannot be null");
        }
        if (servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException("SingleThreadModel Servlet instances are not allowed.");
        }
        ServletRegistration registration = this.servletRegistrations.get(servletName);
        if (registration == null) {
            registration = new ServletRegistration(this, servletName, servlet);
            this.servletRegistrations.put(servletName, registration);
        } else if (registration.servlet != servlet) {
            registration.servlet = servlet;
            registration.servletClass = servlet.getClass();
            registration.className = servlet.getClass().getName();
        }
        return registration;
    }

    public ServletRegistration addServlet(String servletName, String className) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (servletName == null) {
            throw new IllegalArgumentException("'servletName' cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("'className' cannot be null");
        }
        ServletRegistration registration = this.servletRegistrations.get(servletName);
        if (registration == null) {
            registration = new ServletRegistration(this, servletName, className);
            this.servletRegistrations.put(servletName, registration);
        } else if (!registration.className.equals(className)) {
            registration.servlet = null;
            registration.servletClass = null;
            registration.className = className;
        }
        return registration;
    }

    public FilterRegistration getFilterRegistration(String name) {
        if (name == null) {
            return null;
        }
        return this.filterRegistrations.get(name);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.unmodifiableFilterRegistrations;
    }

    public ServletRegistration getServletRegistration(String name) {
        if (name == null) {
            return null;
        }
        return this.servletRegistrations.get(name);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return Collections.unmodifiableMap(this.servletRegistrations);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        if (this.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        try {
            this.addListener(this.createEventListenerInstance(listenerClass));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void addListener(String className) {
        if (this.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (className == null) {
            throw new IllegalArgumentException("'className' cannot be null");
        }
        try {
            this.addListener(this.createEventListenerInstance(className));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends EventListener> void addListener(T eventListener) {
        if (this.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.eventListenerInstances.add(eventListener);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)this.createServletInstance(clazz);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)this.createFilterInstance(clazz);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)this.createEventListenerInstance(clazz);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void declareRoles(String ... roleNames) {
        if (this.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.securityRoles.addAll(Arrays.asList(roleNames));
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk uriDC = dd.uriDC;
        MappingData mappingData = dd.mappingData;
        try {
            uriDC.setString(uri);
            this.dispatcherHelper.mapPath(null, uriDC, mappingData);
            if (mappingData.context == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        if (!(mappingData.context instanceof ServletHandler)) {
            return null;
        }
        ServletHandler context = (ServletHandler)((Object)mappingData.context);
        return context.getServletCtx();
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 1;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return MimeType.get((String)extension);
    }

    public Set<String> getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        File[] files = new File(this.basePath, path).listFiles();
        Set<String> set = Collections.emptySet();
        if (files != null) {
            set = new HashSet<String>(files.length);
            for (File f : files) {
                try {
                    String canonicalPath = f.getCanonicalPath();
                    if (f.isDirectory()) {
                        canonicalPath = canonicalPath + "/";
                    }
                    canonicalPath = canonicalPath.substring(canonicalPath.indexOf(this.basePath) + this.basePath.length());
                    set.add(canonicalPath.replace("\\", "/"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return set;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        if (path.length() > 1) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        String pathLocal = this.normalize(path);
        if (pathLocal == null) {
            return null;
        }
        if (pathLocal.length() > 1) {
            pathLocal = pathLocal.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(pathLocal);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        if (!path.startsWith("/") && !path.isEmpty()) {
            throw new IllegalArgumentException("Path " + path + " does not start with ''/'' and is not empty");
        }
        String queryString = null;
        int pos = path.indexOf(63);
        if (pos >= 0) {
            queryString = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk uriDC = dd.uriDC;
        MappingData mappingData = dd.mappingData;
        try {
            if (this.contextPath.length() == 1 && this.contextPath.charAt(0) == '/') {
                uriDC.setString(path);
            } else {
                uriDC.setString(this.contextPath + path);
            }
            this.dispatcherHelper.mapPath(null, uriDC, mappingData);
            if (mappingData.wrapper == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        if (!(mappingData.wrapper instanceof ServletHandler)) {
            return null;
        }
        ServletHandler wrapper = (ServletHandler)((Object)mappingData.wrapper);
        String wrapperPath = mappingData.wrapperPath.toString();
        String pathInfo = mappingData.pathInfo.toString();
        return new ApplicationDispatcher(wrapper, uriDC.toString(), wrapperPath, pathInfo, queryString, null);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk servletNameDC = dd.servletNameDC;
        MappingData mappingData = dd.mappingData;
        servletNameDC.setString(name);
        try {
            this.dispatcherHelper.mapName(servletNameDC, mappingData);
            if (!(mappingData.wrapper instanceof ServletHandler)) {
                return null;
            }
            ServletHandler h = (ServletHandler)((Object)mappingData.wrapper);
            if (!this.contextPath.equals(h.getContextPath())) {
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        ServletHandler wrapper = (ServletHandler)((Object)mappingData.wrapper);
        return new ApplicationDispatcher(wrapper, null, null, null, null, name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return new Enumerator(Collections.emptyList());
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return new Enumerator(Collections.emptyList());
    }

    public void log(String message) {
        LOGGER.log(Level.INFO, String.format("[%s] %s", this.displayName, message));
    }

    @Deprecated
    public void log(Exception e, String message) {
        this.log(message, e);
    }

    public void log(String message, Throwable throwable) {
        LOGGER.log(Level.INFO, String.format("[%s] %s", this.displayName, message), throwable);
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        return new File(this.basePath, path).getAbsolutePath();
    }

    public String getVirtualServerName() {
        return "server";
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getInitParameter(String name) {
        return this.contextInitParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new Enumerator(this.contextInitParams.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        if (!this.deployed) {
            this.contextInitParams.put(name, value);
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Enumerator(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = this.attributes.put(name, value);
        ServletContextAttributeEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners[i];
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletContextAttributeEvent((ServletContext)this, name, oldValue) : new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR((Object)"ServletContextAttributeListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public void removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        if (value == null) {
            return;
        }
        ServletContextAttributeEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners[i];
            try {
                if (event == null) {
                    event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR((Object)"ServletContextAttributeListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    public String getServletContextName() {
        return this.displayName;
    }

    public javax.servlet.SessionCookieConfig getSessionCookieConfig() {
        if (this.sessionCookieConfig == null) {
            this.sessionCookieConfig = new SessionCookieConfig(this);
        }
        return this.sessionCookieConfig;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            throw new IllegalArgumentException("SSL tracking mode is not supported");
        }
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        this.sessionTrackingModes = Collections.unmodifiableSet(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return DEFAULT_SESSION_TRACKING_MODES;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.sessionTrackingModes != null ? this.sessionTrackingModes : DEFAULT_SESSION_TRACKING_MODES;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.dispatcherHelper = dispatcherHelper;
    }

    protected EventListener[] getEventListeners() {
        return this.eventListeners;
    }

    protected void addFilterMap(FilterMap filterMap, boolean isMatchAfter) {
        String filterName = filterMap.getFilterName();
        String servletName = filterMap.getServletName();
        String urlPattern = filterMap.getURLPattern();
        if (null == this.filterRegistrations.get(filterName)) {
            throw new IllegalArgumentException("Filter mapping specifies an unknown filter name: " + filterName);
        }
        if (servletName == null && urlPattern == null) {
            throw new IllegalArgumentException("Filter mapping must specify either a <url-pattern> or a <servlet-name>");
        }
        if (servletName != null && urlPattern != null) {
            throw new IllegalArgumentException("Filter mapping must specify either a <url-pattern> or a <servlet-name>");
        }
        if (urlPattern != null && !this.validateURLPattern(urlPattern)) {
            throw new IllegalArgumentException("Invalid <url-pattern> {0} in filter mapping: " + urlPattern);
        }
        if (isMatchAfter) {
            this.filterMaps.add(filterMap);
        } else {
            this.filterMaps.add(0, filterMap);
        }
    }

    protected List<FilterMap> getFilterMaps() {
        return this.filterMaps;
    }

    protected void removeFilterMaps() {
        this.filterMaps.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getServletNameFilterMappings(String filterName) {
        HashSet<String> mappings = new HashSet<String>();
        List<FilterMap> list = this.filterMaps;
        synchronized (list) {
            for (FilterMap fm : this.filterMaps) {
                if (!filterName.equals(fm.getFilterName()) || fm.getServletName() == null) continue;
                mappings.add(fm.getServletName());
            }
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getUrlPatternFilterMappings(String filterName) {
        HashSet<String> mappings = new HashSet<String>();
        List<FilterMap> list = this.filterMaps;
        synchronized (list) {
            for (FilterMap fm : this.filterMaps) {
                if (!filterName.equals(fm.getFilterName()) || fm.getURLPattern() == null) continue;
                mappings.add(fm.getURLPattern());
            }
        }
        return mappings;
    }

    protected FilterChainFactory getFilterChainFactory() {
        return this.filterChainFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterFilter(Filter f) {
        Map<String, FilterRegistration> map = this.filterRegistrations;
        synchronized (map) {
            Iterator<FilterRegistration> i = this.filterRegistrations.values().iterator();
            while (i.hasNext()) {
                FilterRegistration registration = i.next();
                if (registration.filter != f) continue;
                Iterator<FilterMap> fmi = this.filterMaps.iterator();
                while (fmi.hasNext()) {
                    FilterMap fm = fmi.next();
                    if (!fm.getFilterName().equals(registration.name)) continue;
                    fmi.remove();
                }
                f.destroy();
                i.remove();
            }
        }
    }

    protected void unregisterAllFilters() {
        this.destroyFilters();
    }

    protected void destroyFilters() {
        for (FilterRegistration registration : this.filterRegistrations.values()) {
            registration.filter.destroy();
        }
        this.removeFilterMaps();
    }

    private void destoryServlets(HttpServer server) {
        if (this.servletHandlers != null && !this.servletHandlers.isEmpty()) {
            ServerConfiguration config = server.getServerConfiguration();
            for (ServletHandler handler : this.servletHandlers) {
                config.removeHttpHandler((HttpHandler)handler);
            }
        }
    }

    private void initializeListeners() throws ServletException {
        if (!this.eventListenerInstances.isEmpty()) {
            this.eventListeners = this.eventListenerInstances.toArray(new EventListener[this.eventListenerInstances.size()]);
        }
    }

    private void initServlets(HttpServer server) throws ServletException {
        boolean defaultMappingAdded = false;
        if (!this.servletRegistrations.isEmpty()) {
            ServerConfiguration serverConfig = server.getServerConfiguration();
            this.servletHandlers = new LinkedHashSet<ServletHandler>(this.servletRegistrations.size(), 1.0f);
            LinkedList<ServletRegistration> sortedRegistrations = new LinkedList<ServletRegistration>(this.servletRegistrations.values());
            Collections.sort(sortedRegistrations);
            for (ServletRegistration registration : sortedRegistrations) {
                ServletConfigImpl sConfig = this.createServletConfig(registration);
                if (registration.servlet != null) {
                    try {
                        registration.servlet.init((ServletConfig)sConfig);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (registration.loadOnStartup >= 0) {
                    try {
                        Servlet servletInstance = this.createServletInstance(registration);
                        LOGGER.log(Level.INFO, "Loading Servlet: {0}", servletInstance.getClass().getName());
                        servletInstance.init((ServletConfig)sConfig);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ServletHandler servletHandler = new ServletHandler(sConfig);
                servletHandler.setServletInstance(registration.servlet);
                servletHandler.setServletClass(registration.servletClass);
                servletHandler.setServletClassName(registration.className);
                servletHandler.setContextPath(this.contextPath);
                servletHandler.setFilterChainFactory(this.filterChainFactory);
                servletHandler.setExpectationHandler(registration.expectationHandler);
                servletHandler.addOnDestroyListener(this.onDestroyListener);
                servletHandler.setClassLoader(this.webappClassLoader);
                Object[] patterns = (String[])registration.urlPatterns.getArray();
                if (patterns != null && patterns.length > 0) {
                    for (String string : patterns) {
                        if (string.length() == 0 || "/".equals(string)) {
                            defaultMappingAdded = true;
                        }
                        serverConfig.addHttpHandler((HttpHandler)servletHandler, new String[]{WebappContext.updateMappings(servletHandler, string)});
                    }
                } else {
                    serverConfig.addHttpHandler((HttpHandler)servletHandler, new String[]{WebappContext.updateMappings(servletHandler, "")});
                }
                this.servletHandlers.add(servletHandler);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                String p = patterns == null ? "" : Arrays.toString(patterns);
                LOGGER.log(Level.INFO, "[{0}] Servlet [{1}] registered for url pattern(s) [{2}].", new Object[]{this.displayName, registration.className, p});
            }
        }
        if (!defaultMappingAdded) {
            this.registerDefaultServlet(server);
        }
    }

    private void registerDefaultServlet(HttpServer server) {
        ServerConfiguration serverConfig = server.getServerConfiguration();
        Map handlers = serverConfig.getHttpHandlers();
        for (Map.Entry entry : handlers.entrySet()) {
            String[] mappings;
            HttpHandler h = (HttpHandler)entry.getKey();
            if (!(h instanceof StaticHttpHandler)) continue;
            for (String mapping : mappings = (String[])entry.getValue()) {
                if (!"/".equals(mapping)) continue;
                DefaultServlet s = new DefaultServlet((ArraySet<File>)((StaticHttpHandler)h).getDocRoots());
                ServletRegistration registration = this.addServlet("DefaultServlet", (Servlet)s);
                registration.addMapping("/");
                ServletConfigImpl sConfig = this.createServletConfig(registration);
                try {
                    s.init(sConfig);
                }
                catch (ServletException ignored) {
                    // empty catch block
                }
                ServletHandler servletHandler = new ServletHandler(sConfig);
                servletHandler.setServletInstance(registration.servlet);
                servletHandler.setServletClass(registration.servletClass);
                servletHandler.setServletClassName(registration.className);
                servletHandler.setContextPath(this.contextPath);
                servletHandler.setFilterChainFactory(this.filterChainFactory);
                servletHandler.setExpectationHandler(registration.expectationHandler);
                servletHandler.addOnDestroyListener(this.onDestroyListener);
                serverConfig.addHttpHandler((HttpHandler)servletHandler, new String[]{WebappContext.updateMappings(servletHandler, "/")});
                if (this.servletHandlers == null) {
                    this.servletHandlers = new LinkedHashSet<ServletHandler>(1, 1.0f);
                }
                this.servletHandlers.add(servletHandler);
            }
        }
    }

    private void initFilters() {
        if (!this.filterRegistrations.isEmpty()) {
            for (FilterRegistration registration : this.filterRegistrations.values()) {
                try {
                    Filter f = registration.filter;
                    if (f == null) {
                        f = this.createFilterInstance(registration);
                    }
                    FilterConfigImpl filterConfig = this.createFilterConfig(registration);
                    registration.filter = f;
                    f.init((FilterConfig)filterConfig);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.log(Level.INFO, "[{0}] Filter [{1}] registered for url pattern(s) [{2}] and servlet name(s) [{3}]", new Object[]{this.displayName, registration.className, registration.getUrlPatternMappings(), registration.getServletNameMappings()});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static String updateMappings(ServletHandler handler, String mapping) {
        String mappingLocal = mapping;
        if (mappingLocal.length() == 0) {
            mappingLocal = "/";
        } else {
            if (mappingLocal.charAt(0) == '*') {
                mappingLocal = "/" + mapping;
            }
            if (mappingLocal.indexOf("//", 1) != -1) {
                mappingLocal = mappingLocal.replaceAll("//", "/");
            }
        }
        String contextPath = handler.getContextPath();
        contextPath = contextPath.length() == 0 ? "/" : contextPath;
        return contextPath + mappingLocal;
    }

    private FilterConfigImpl createFilterConfig(FilterRegistration registration) {
        FilterConfigImpl fConfig = new FilterConfigImpl(this);
        fConfig.setFilterName(registration.getName());
        if (!registration.initParameters.isEmpty()) {
            fConfig.setInitParameters(registration.initParameters);
        }
        return fConfig;
    }

    private ServletConfigImpl createServletConfig(ServletRegistration registration) {
        ServletConfigImpl sConfig = new ServletConfigImpl(this);
        sConfig.setServletName(registration.getName());
        if (!registration.initParameters.isEmpty()) {
            sConfig.setInitParameters(registration.initParameters);
        }
        return sConfig;
    }

    private void contextInitialized() {
        ServletContextEvent event = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webappClassLoader);
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners[i];
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextInitialized(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR((Object)"contextInitialized", (Object)"ServletContextListener", (Object)listener.getClass().getName()), t);
            }
        }
        Thread.currentThread().setContextClassLoader(loader);
    }

    private void contextDestroyed() {
        ServletContextEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners[i];
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextDestroyed(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR((Object)"contextDestroyed", (Object)"ServletContextListener", (Object)listener.getClass().getName()), t);
            }
        }
    }

    protected Servlet createServletInstance(ServletRegistration registration) throws Exception {
        String servletClassName = registration.className;
        Class<? extends Servlet> servletClass = registration.servletClass;
        if (servletClassName != null) {
            return (Servlet)ClassLoaderUtil.load((String)servletClassName);
        }
        return this.createServletInstance(servletClass);
    }

    protected Servlet createServletInstance(Class<? extends Servlet> servletClass) throws Exception {
        return servletClass.newInstance();
    }

    protected Filter createFilterInstance(FilterRegistration registration) throws Exception {
        String filterClassName = registration.className;
        Class<? extends Filter> filterClass = registration.filterClass;
        if (filterClassName != null) {
            return (Filter)ClassLoaderUtil.load((String)filterClassName);
        }
        return this.createFilterInstance(filterClass);
    }

    protected Filter createFilterInstance(Class<? extends Filter> filterClass) throws Exception {
        return filterClass.newInstance();
    }

    protected EventListener createEventListenerInstance(Class<? extends EventListener> eventListenerClass) throws Exception {
        return eventListenerClass.newInstance();
    }

    protected EventListener createEventListenerInstance(String eventListenerClassname) throws Exception {
        return (EventListener)ClassLoaderUtil.load((String)eventListenerClassname);
    }

    public <T extends HttpUpgradeHandler> T createHttpUpgradeHandlerInstance(Class<T> clazz) throws Exception {
        return (T)((HttpUpgradeHandler)clazz.newInstance());
    }

    protected boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.isEmpty()) {
            return true;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            LOGGER.log(Level.WARNING, "The URL pattern ''{0}'' contains a CR or LF and so can never be matched", urlPattern);
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf(47) < 0) {
                this.checkUnusualURLPattern(urlPattern);
                return true;
            }
            return false;
        }
        if (urlPattern.startsWith("/") && !urlPattern.contains("*.")) {
            this.checkUnusualURLPattern(urlPattern);
            return true;
        }
        return false;
    }

    private void checkUnusualURLPattern(String urlPattern) {
        if (LOGGER.isLoggable(Level.INFO) && urlPattern.endsWith("*") && (urlPattern.length() < 2 || urlPattern.charAt(urlPattern.length() - 2) != '/')) {
            LOGGER.log(Level.INFO, "Suspicious url pattern: \"{0}\" in context - see section SRV.11.2 of the Servlet specification", urlPattern);
        }
    }

    private static final class DispatchData {
        public final DataChunk uriDC = DataChunk.newInstance();
        public final DataChunk servletNameDC = DataChunk.newInstance();
        public final MappingData mappingData = new MappingData();

        public void recycle() {
            this.uriDC.recycle();
            this.servletNameDC.recycle();
            this.mappingData.recycle();
        }
    }
}

