/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.PerInstanceResourceMonitorMBean;

public class PerInstanceResourceMonitor
implements PerInstanceResourceMonitorMBean {
    private final String _clusterName;
    private List<String> _tags;
    private final String _participantName;
    private final String _resourceName;
    private long _partitions;

    public PerInstanceResourceMonitor(String clusterName, String participantName, String resourceName) {
        this._clusterName = clusterName;
        this._tags = ImmutableList.of((Object)"DEFAULT");
        this._participantName = participantName;
        this._resourceName = resourceName;
        this._partitions = 0L;
    }

    @Override
    public String getSensorName() {
        return Joiner.on((char)'.').join((Iterable)ImmutableList.of((Object)"ParticipantStatus", (Object)this._clusterName, (Object)this.serializedTags(), (Object)this._participantName, (Object)this._resourceName)).toString();
    }

    private String serializedTags() {
        return Joiner.on((char)'|').skipNulls().join(this._tags).toString();
    }

    @Override
    public long getPartitionGauge() {
        return this._partitions;
    }

    public String getInstanceName() {
        return this._participantName;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public synchronized void update(Map<Partition, String> stateMap, Set<String> tags, StateModelDefinition stateModelDef) {
        if (tags == null || tags.isEmpty()) {
            this._tags = ImmutableList.of((Object)"DEFAULT");
        } else {
            this._tags = Lists.newArrayList(tags);
            Collections.sort(this._tags);
        }
        int cnt = 0;
        for (String state : stateMap.values()) {
            if (state.equalsIgnoreCase(HelixDefinedState.DROPPED.name()) || state.equalsIgnoreCase(stateModelDef.getInitialState())) continue;
            ++cnt;
        }
        this._partitions = cnt;
    }

    public static class BeanName {
        private final String _instanceName;
        private final String _resourceName;

        public BeanName(String instanceName, String resourceName) {
            if (instanceName == null || resourceName == null) {
                throw new NullPointerException("Illegal beanName. instanceName: " + instanceName + ", resourceName: " + resourceName);
            }
            this._instanceName = instanceName;
            this._resourceName = resourceName;
        }

        public String instanceName() {
            return this._instanceName;
        }

        public String resourceName() {
            return this._resourceName;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof BeanName)) {
                return false;
            }
            BeanName that = (BeanName)obj;
            return this._instanceName.equals(that._instanceName) && this._resourceName.equals(that._resourceName);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.format("%s=%s,%s=%s", "instanceName", this._instanceName, "resourceName", this._resourceName);
        }
    }
}

