/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import org.apache.helix.PropertyKey;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorResource.class);

    public ErrorResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            String instanceName = (String)this.getRequest().getAttributes().get("instanceName");
            String resourceGroup = (String)this.getRequest().getAttributes().get("resourceName");
            presentation = this.getInstanceErrorsRepresentation(clusterName, instanceName, resourceGroup);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getInstanceErrorsRepresentation(String clusterName, String instanceName, String resourceGroup) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        String instanceSessionId = ClusterRepresentationUtil.getInstanceSessionId(zkClient, clusterName, instanceName);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String message = ClusterRepresentationUtil.getInstancePropertiesAsString(zkClient, clusterName, keyBuilder.stateTransitionErrors(instanceName, instanceSessionId, resourceGroup), MediaType.APPLICATION_JSON);
        StringRepresentation representation = new StringRepresentation((CharSequence)message, MediaType.APPLICATION_JSON);
        return representation;
    }
}

