/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.AbstractStatisticsHandler;

public class StatisticsHandler
extends AbstractStatisticsHandler {
    private transient long _statsStartedAt;
    private transient int _requests;
    private transient long _minRequestTime;
    private transient long _maxRequestTime;
    private transient long _totalRequestTime;
    private transient int _requestsActive;
    private transient int _requestsActiveMax;
    private transient int _responses1xx;
    private transient int _responses2xx;
    private transient int _responses3xx;
    private transient int _responses4xx;
    private transient int _responses5xx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            ++this._requests;
            ++this._requestsActive;
            if (this._requestsActive > this._requestsActiveMax) {
                this._requestsActiveMax = this._requestsActive;
            }
        }
        long requestStartTime = System.currentTimeMillis();
        try {
            super.handle(target, request, response, dispatch);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            long requestTime = System.currentTimeMillis() - requestStartTime;
            StatisticsHandler statisticsHandler2 = this;
            synchronized (statisticsHandler2) {
                --this._requestsActive;
                if (this._requestsActive < 0) {
                    this._requestsActive = 0;
                }
                this._totalRequestTime += requestTime;
                if (requestTime < this._minRequestTime || this._minRequestTime == 0L) {
                    this._minRequestTime = requestTime;
                }
                if (requestTime > this._maxRequestTime) {
                    this._maxRequestTime = requestTime;
                }
                Response jettyResponse = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
                switch (jettyResponse.getStatus() / 100) {
                    case 1: {
                        ++this._responses1xx;
                        break;
                    }
                    case 2: {
                        ++this._responses2xx;
                        break;
                    }
                    case 3: {
                        ++this._responses3xx;
                        break;
                    }
                    case 4: {
                        ++this._responses4xx;
                        break;
                    }
                    case 5: {
                        ++this._responses5xx;
                        break;
                    }
                }
            }
            throw throwable;
        }
        long requestTime = System.currentTimeMillis() - requestStartTime;
        StatisticsHandler statisticsHandler3 = this;
        synchronized (statisticsHandler3) {
            --this._requestsActive;
            if (this._requestsActive < 0) {
                this._requestsActive = 0;
            }
            this._totalRequestTime += requestTime;
            if (requestTime < this._minRequestTime || this._minRequestTime == 0L) {
                this._minRequestTime = requestTime;
            }
            if (requestTime > this._maxRequestTime) {
                this._maxRequestTime = requestTime;
            }
            Response jettyResponse = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
            switch (jettyResponse.getStatus() / 100) {
                case 1: {
                    ++this._responses1xx;
                    break;
                }
                case 2: {
                    ++this._responses2xx;
                    break;
                }
                case 3: {
                    ++this._responses3xx;
                    break;
                }
                case 4: {
                    ++this._responses4xx;
                    break;
                }
                case 5: {
                    ++this._responses5xx;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statsReset() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            this._statsStartedAt = System.currentTimeMillis();
            this._requests = 0;
            this._minRequestTime = 0L;
            this._maxRequestTime = 0L;
            this._totalRequestTime = 0L;
            this._requestsActiveMax = this._requestsActive;
            this._requestsActive = 0;
            this._responses1xx = 0;
            this._responses2xx = 0;
            this._responses3xx = 0;
            this._responses4xx = 0;
            this._responses5xx = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequests() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestsActive() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requestsActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestsActiveMax() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requestsActiveMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponses1xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses1xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponses2xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses2xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponses3xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses3xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponses4xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses4xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponses5xx() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._responses5xx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStatsOnMs() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return System.currentTimeMillis() - this._statsStartedAt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRequestTimeMin() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._minRequestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRequestTimeMax() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._maxRequestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRequestTimeTotal() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._totalRequestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRequestTimeAverage() {
        StatisticsHandler statisticsHandler = this;
        synchronized (statisticsHandler) {
            return this._requests == 0 ? 0L : this._totalRequestTime / (long)this._requests;
        }
    }
}

