/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreateTopicsResponse
extends AbstractResponse {
    private static final String TOPIC_ERRORS_KEY_NAME = "topic_errors";
    private static final Schema TOPIC_ERROR_CODE = new Schema(CommonFields.TOPIC_NAME, CommonFields.ERROR_CODE);
    private static final Schema TOPIC_ERROR = new Schema(CommonFields.TOPIC_NAME, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE);
    private static final Schema CREATE_TOPICS_RESPONSE_V0 = new Schema(new Field("topic_errors", new ArrayOf(TOPIC_ERROR_CODE), "An array of per topic error codes."));
    private static final Schema CREATE_TOPICS_RESPONSE_V1 = new Schema(new Field("topic_errors", new ArrayOf(TOPIC_ERROR), "An array of per topic errors."));
    private static final Schema CREATE_TOPICS_RESPONSE_V2;
    private static final Schema CREATE_TOPICS_RESPONSE_V3;
    private final Map<String, ApiError> errors;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_TOPICS_RESPONSE_V0, CREATE_TOPICS_RESPONSE_V1, CREATE_TOPICS_RESPONSE_V2, CREATE_TOPICS_RESPONSE_V3};
    }

    public CreateTopicsResponse(Map<String, ApiError> errors) {
        this(0, errors);
    }

    public CreateTopicsResponse(int throttleTimeMs, Map<String, ApiError> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public CreateTopicsResponse(Struct struct) {
        Object[] topicErrorStructs = struct.getArray(TOPIC_ERRORS_KEY_NAME);
        HashMap<String, ApiError> errors = new HashMap<String, ApiError>();
        for (Object topicErrorStructObj : topicErrorStructs) {
            Struct topicErrorStruct = (Struct)topicErrorStructObj;
            String topic = topicErrorStruct.get(CommonFields.TOPIC_NAME);
            errors.put(topic, new ApiError(topicErrorStruct));
        }
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_TOPICS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        ArrayList<Struct> topicErrorsStructs = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<String, ApiError> topicError : this.errors.entrySet()) {
            Struct topicErrorsStruct = struct.instance(TOPIC_ERRORS_KEY_NAME);
            topicErrorsStruct.set(CommonFields.TOPIC_NAME, topicError.getKey());
            topicError.getValue().write(topicErrorsStruct);
            topicErrorsStructs.add(topicErrorsStruct);
        }
        struct.set(TOPIC_ERRORS_KEY_NAME, (Object)topicErrorsStructs.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, ApiError> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.apiErrorCounts(this.errors);
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer, short version) {
        return new CreateTopicsResponse(ApiKeys.CREATE_TOPICS.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }

    static {
        CREATE_TOPICS_RESPONSE_V3 = CREATE_TOPICS_RESPONSE_V2 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(TOPIC_ERRORS_KEY_NAME, new ArrayOf(TOPIC_ERROR), "An array of per topic errors."));
    }
}

