/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RpcThrottleStorage {
    public static final String RPC_THROTTLE_ZNODE = "zookeeper.znode.quota.rpc.throttle";
    public static final String RPC_THROTTLE_ZNODE_DEFAULT = "rpc-throttle";
    private final ZKWatcher zookeeper;
    private final String rpcThrottleZNode;

    public RpcThrottleStorage(ZKWatcher zookeeper, Configuration conf) {
        this.zookeeper = zookeeper;
        this.rpcThrottleZNode = ZNodePaths.joinZNode(zookeeper.getZNodePaths().baseZNode, conf.get(RPC_THROTTLE_ZNODE, RPC_THROTTLE_ZNODE_DEFAULT));
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        try {
            byte[] upData = ZKUtil.getData(this.zookeeper, this.rpcThrottleZNode);
            return upData == null || Bytes.toBoolean(upData);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed to get rpc throttle", e);
        }
    }

    public void switchRpcThrottle(boolean enable) throws IOException {
        try {
            byte[] upData = Bytes.toBytes(enable);
            ZKUtil.createSetData(this.zookeeper, this.rpcThrottleZNode, upData);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to store rpc throttle", e);
        }
    }
}

