/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DrainingServerTracker
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(DrainingServerTracker.class);
    private ServerManager serverManager;
    private final NavigableSet<ServerName> drainingServers = new TreeSet<ServerName>();
    private Abortable abortable;

    public DrainingServerTracker(ZKWatcher watcher, Abortable abortable, ServerManager serverManager) {
        super(watcher);
        this.abortable = abortable;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException, IOException {
        this.watcher.registerListener(this);
        this.serverManager.registerListener(new ServerListener(){

            @Override
            public void serverAdded(ServerName sn) {
                if (DrainingServerTracker.this.drainingServers.contains(sn)) {
                    DrainingServerTracker.this.serverManager.addServerToDrainList(sn);
                }
            }
        });
        List<String> servers = ZKUtil.listChildrenAndWatchThem(this.watcher, this.watcher.getZNodePaths().drainingZNode);
        this.add(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(List<String> servers) throws IOException {
        NavigableSet<ServerName> navigableSet = this.drainingServers;
        synchronized (navigableSet) {
            this.drainingServers.clear();
            for (String n : servers) {
                ServerName sn = ServerName.valueOf(ZKUtil.getNodeName(n));
                this.drainingServers.add(sn);
                this.serverManager.addServerToDrainList(sn);
                LOG.info("Draining RS node created, adding to list [" + sn + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServerName sn) {
        NavigableSet<ServerName> navigableSet = this.drainingServers;
        synchronized (navigableSet) {
            this.drainingServers.remove(sn);
            this.serverManager.removeServerFromDrainList(sn);
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.getZNodePaths().drainingZNode)) {
            ServerName sn = ServerName.valueOf(ZKUtil.getNodeName(path));
            LOG.info("Draining RS node deleted, removing from list [" + sn + "]");
            this.remove(sn);
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.getZNodePaths().drainingZNode)) {
            try {
                List<String> newNodes = ZKUtil.listChildrenAndWatchThem(this.watcher, this.watcher.getZNodePaths().drainingZNode);
                this.add(newNodes);
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", e);
            }
            catch (IOException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", e);
            }
        }
    }
}

