/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ColumnRangeFilter
extends FilterBase {
    protected byte[] minColumn = null;
    protected boolean minColumnInclusive = true;
    protected byte[] maxColumn = null;
    protected boolean maxColumnInclusive = false;

    public ColumnRangeFilter(byte[] minColumn, boolean minColumnInclusive, byte[] maxColumn, boolean maxColumnInclusive) {
        this.minColumn = minColumn;
        this.minColumnInclusive = minColumnInclusive;
        this.maxColumn = maxColumn;
        this.maxColumnInclusive = maxColumnInclusive;
    }

    public boolean isMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public boolean isMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    public byte[] getMinColumn() {
        return this.minColumn;
    }

    public boolean getMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public byte[] getMaxColumn() {
        return this.maxColumn;
    }

    public boolean getMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        int cmpMin = 1;
        if (this.minColumn != null) {
            cmpMin = CellUtil.compareQualifiers((Cell)c, (byte[])this.minColumn, (int)0, (int)this.minColumn.length);
        }
        if (cmpMin < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (!this.minColumnInclusive && cmpMin == 0) {
            return Filter.ReturnCode.NEXT_COL;
        }
        if (this.maxColumn == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        int cmpMax = CellUtil.compareQualifiers((Cell)c, (byte[])this.maxColumn, (int)0, (int)this.maxColumn.length);
        if (this.maxColumnInclusive && cmpMax <= 0 || !this.maxColumnInclusive && cmpMax < 0) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.NEXT_ROW;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 4 ? 1 : 0) != 0, (String)"Expected 4 but got: %s", (int)filterArguments.size());
        byte[] minColumn = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        boolean minColumnInclusive = ParseFilter.convertByteArrayToBoolean(filterArguments.get(1));
        byte[] maxColumn = ParseFilter.removeQuotesFromByteArray(filterArguments.get(2));
        boolean maxColumnInclusive = ParseFilter.convertByteArrayToBoolean(filterArguments.get(3));
        if (minColumn.length == 0) {
            minColumn = null;
        }
        if (maxColumn.length == 0) {
            maxColumn = null;
        }
        return new ColumnRangeFilter(minColumn, minColumnInclusive, maxColumn, maxColumnInclusive);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnRangeFilter.Builder builder = FilterProtos.ColumnRangeFilter.newBuilder();
        if (this.minColumn != null) {
            builder.setMinColumn(UnsafeByteOperations.unsafeWrap((byte[])this.minColumn));
        }
        builder.setMinColumnInclusive(this.minColumnInclusive);
        if (this.maxColumn != null) {
            builder.setMaxColumn(UnsafeByteOperations.unsafeWrap((byte[])this.maxColumn));
        }
        builder.setMaxColumnInclusive(this.maxColumnInclusive);
        return builder.build().toByteArray();
    }

    public static ColumnRangeFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnRangeFilter proto;
        try {
            proto = FilterProtos.ColumnRangeFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new ColumnRangeFilter(proto.hasMinColumn() ? proto.getMinColumn().toByteArray() : null, proto.getMinColumnInclusive(), proto.hasMaxColumn() ? proto.getMaxColumn().toByteArray() : null, proto.getMaxColumnInclusive());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnRangeFilter)) {
            return false;
        }
        ColumnRangeFilter other = (ColumnRangeFilter)o;
        return Bytes.equals((byte[])this.getMinColumn(), (byte[])other.getMinColumn()) && this.getMinColumnInclusive() == other.getMinColumnInclusive() && Bytes.equals((byte[])this.getMaxColumn(), (byte[])other.getMaxColumn()) && this.getMaxColumnInclusive() == other.getMaxColumnInclusive();
    }

    @Override
    public Cell getNextCellHint(Cell cell) {
        return PrivateCellUtil.createFirstOnRowCol((Cell)cell, (byte[])this.minColumn, (int)0, (int)Bytes.len((byte[])this.minColumn));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + (this.minColumnInclusive ? "[" : "(") + Bytes.toStringBinary((byte[])this.minColumn) + ", " + Bytes.toStringBinary((byte[])this.maxColumn) + (this.maxColumnInclusive ? "]" : ")");
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(Bytes.hashCode((byte[])this.getMinColumn()), this.getMinColumnInclusive(), Bytes.hashCode((byte[])this.getMaxColumn()), this.getMaxColumnInclusive());
    }
}

