/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class JmxCacheBuster {
    private static final Logger LOG = LoggerFactory.getLogger(JmxCacheBuster.class);
    private static AtomicReference<ScheduledFuture> fut = new AtomicReference<Object>(null);
    private static MetricsExecutor executor = new MetricsExecutorImpl();
    private static AtomicBoolean stopped = new AtomicBoolean(false);

    private JmxCacheBuster() {
    }

    public static void clearJmxCache() {
        ScheduledFuture<?> future;
        if (LOG.isTraceEnabled()) {
            LOG.trace("clearing JMX Cache" + StringUtils.stringifyException(new Exception()));
        }
        if ((future = fut.get()) != null && !future.isDone() && future.getDelay(TimeUnit.MILLISECONDS) > 100L) {
            return;
        }
        if (stopped.get()) {
            return;
        }
        future = executor.getExecutor().schedule(new JmxCacheBusterRunnable(), 5L, TimeUnit.SECONDS);
        fut.set(future);
    }

    public static void stop() {
        stopped.set(true);
        ScheduledFuture future = fut.get();
        future.cancel(false);
    }

    public static void restart() {
        stopped.set(false);
    }

    static final class JmxCacheBusterRunnable
    implements Runnable {
        JmxCacheBusterRunnable() {
        }

        @Override
        public void run() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Clearing JMX mbean cache.");
            }
            try {
                if (DefaultMetricsSystem.instance() != null) {
                    DefaultMetricsSystem.instance().stop();
                    Thread.sleep(500L);
                    DefaultMetricsSystem.instance().start();
                }
            }
            catch (Exception exception) {
                LOG.debug("error clearing the jmx it appears the metrics system hasn't been started", (Throwable)exception);
            }
        }
    }
}

