/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.tgsReq.actions;

import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.kdcReq.KdcReqContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.tgsReq.TgsReqContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.messages.TgsReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreKdcReq
extends GrammarAction<TgsReqContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreKdcReq.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreKdcReq() {
        super("Add an KDC-REQ instance");
    }

    public void action(TgsReqContainer tgsReqContainer) throws DecoderException {
        TLV tlv = tgsReqContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder kdcReqDecoder = new Asn1Decoder();
        KdcReqContainer kdcReqContainer = new KdcReqContainer(tgsReqContainer.getStream());
        TgsReq tgsReq = new TgsReq();
        kdcReqContainer.setKdcReq(tgsReq);
        kdcReqDecoder.decode(tgsReqContainer.getStream(), (Asn1Container)kdcReqContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        tgsReqContainer.updateParent();
        if (tgsReq.getMessageType() != KerberosMessageType.TGS_REQ) {
            throw new DecoderException("Bad message type");
        }
        tgsReqContainer.setTgsReq(tgsReq);
        if (IS_DEBUG) {
            LOG.debug("TGS-REQ : {}", (Object)tgsReq);
        }
        tgsReqContainer.setGrammarEndAllowed(true);
    }
}

