/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class UnsafeAccess {
    public static final long BYTE_ARRAY_BASE_OFFSET;
    public static final boolean LITTLE_ENDIAN;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeAccess() {
    }

    public static short toShort(byte[] bytes, int offset) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(HBasePlatformDependent.getShort((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET)));
        }
        return HBasePlatformDependent.getShort((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET));
    }

    public static int toInt(byte[] bytes, int offset) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(HBasePlatformDependent.getInt((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET)));
        }
        return HBasePlatformDependent.getInt((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET));
    }

    public static long toLong(byte[] bytes, int offset) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(HBasePlatformDependent.getLong((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET)));
        }
        return HBasePlatformDependent.getLong((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET));
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (LITTLE_ENDIAN) {
            val = Short.reverseBytes(val);
        }
        HBasePlatformDependent.putShort((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET), (short)val);
        return offset + 2;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        HBasePlatformDependent.putInt((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET), (int)val);
        return offset + 4;
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (LITTLE_ENDIAN) {
            val = Long.reverseBytes(val);
        }
        HBasePlatformDependent.putLong((Object)bytes, (long)((long)offset + BYTE_ARRAY_BASE_OFFSET), (long)val);
        return offset + 8;
    }

    public static short toShort(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(UnsafeAccess.getAsShort(buf, offset));
        }
        return UnsafeAccess.getAsShort(buf, offset);
    }

    public static short toShort(Object ref, long offset) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(HBasePlatformDependent.getShort((Object)ref, (long)offset));
        }
        return HBasePlatformDependent.getShort((Object)ref, (long)offset);
    }

    private static short getAsShort(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return HBasePlatformDependent.getShort((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset));
        }
        return HBasePlatformDependent.getShort((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset));
    }

    public static int toInt(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(UnsafeAccess.getAsInt(buf, offset));
        }
        return UnsafeAccess.getAsInt(buf, offset);
    }

    public static int toInt(Object ref, long offset) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(HBasePlatformDependent.getInt((Object)ref, (long)offset));
        }
        return HBasePlatformDependent.getInt((Object)ref, (long)offset);
    }

    private static int getAsInt(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return HBasePlatformDependent.getInt((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset));
        }
        return HBasePlatformDependent.getInt((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset));
    }

    public static long toLong(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(UnsafeAccess.getAsLong(buf, offset));
        }
        return UnsafeAccess.getAsLong(buf, offset);
    }

    public static long toLong(Object ref, long offset) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(HBasePlatformDependent.getLong((Object)ref, (long)offset));
        }
        return HBasePlatformDependent.getLong((Object)ref, (long)offset);
    }

    private static long getAsLong(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return HBasePlatformDependent.getLong((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset));
        }
        return HBasePlatformDependent.getLong((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset));
    }

    public static byte toByte(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return HBasePlatformDependent.getByte((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset));
        }
        return HBasePlatformDependent.getByte((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset));
    }

    public static byte toByte(Object ref, long offset) {
        return HBasePlatformDependent.getByte((Object)ref, (long)offset);
    }

    public static int putInt(ByteBuffer buf, int offset, int val) {
        if (LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        if (buf.isDirect()) {
            HBasePlatformDependent.putInt((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset), (int)val);
        } else {
            HBasePlatformDependent.putInt((Object)buf.array(), (long)((long)(offset + buf.arrayOffset()) + BYTE_ARRAY_BASE_OFFSET), (int)val);
        }
        return offset + 4;
    }

    public static void copy(byte[] src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress = destOffset;
        byte[] destBase = null;
        if (dest.isDirect()) {
            destAddress += UnsafeAccess.directBufferAddress(dest);
        } else {
            destAddress = destAddress + BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        long srcAddress = (long)srcOffset + BYTE_ARRAY_BASE_OFFSET;
        UnsafeAccess.unsafeCopy(src, srcAddress, destBase, destAddress, length);
    }

    private static void unsafeCopy(Object src, long srcAddr, Object dst, long destAddr, long len) {
        while (len > 0L) {
            long size = len > 0x100000L ? 0x100000L : len;
            HBasePlatformDependent.copyMemory((Object)src, (long)srcAddr, (Object)dst, (long)destAddr, (long)size);
            len -= size;
            srcAddr += size;
            destAddr += size;
        }
    }

    public static void copy(ByteBuffer src, int srcOffset, byte[] dest, int destOffset, int length) {
        long srcAddress = srcOffset;
        byte[] srcBase = null;
        if (src.isDirect()) {
            srcAddress += UnsafeAccess.directBufferAddress(src);
        } else {
            srcAddress = srcAddress + BYTE_ARRAY_BASE_OFFSET + (long)src.arrayOffset();
            srcBase = src.array();
        }
        long destAddress = (long)destOffset + BYTE_ARRAY_BASE_OFFSET;
        UnsafeAccess.unsafeCopy(srcBase, srcAddress, dest, destAddress, length);
    }

    public static void copy(ByteBuffer src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress;
        long srcAddress;
        byte[] srcBase = null;
        byte[] destBase = null;
        if (src.isDirect()) {
            srcAddress = (long)srcOffset + UnsafeAccess.directBufferAddress(src);
        } else {
            srcAddress = (long)srcOffset + (long)src.arrayOffset() + BYTE_ARRAY_BASE_OFFSET;
            srcBase = src.array();
        }
        if (dest.isDirect()) {
            destAddress = (long)destOffset + UnsafeAccess.directBufferAddress(dest);
        } else {
            destAddress = (long)destOffset + BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        UnsafeAccess.unsafeCopy(srcBase, srcAddress, destBase, destAddress, length);
    }

    public static int putShort(ByteBuffer buf, int offset, short val) {
        if (LITTLE_ENDIAN) {
            val = Short.reverseBytes(val);
        }
        if (buf.isDirect()) {
            HBasePlatformDependent.putShort((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset), (short)val);
        } else {
            HBasePlatformDependent.putShort((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset), (short)val);
        }
        return offset + 2;
    }

    public static int putLong(ByteBuffer buf, int offset, long val) {
        if (LITTLE_ENDIAN) {
            val = Long.reverseBytes(val);
        }
        if (buf.isDirect()) {
            HBasePlatformDependent.putLong((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset), (long)val);
        } else {
            HBasePlatformDependent.putLong((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset), (long)val);
        }
        return offset + 8;
    }

    public static int putByte(ByteBuffer buf, int offset, byte b) {
        if (buf.isDirect()) {
            HBasePlatformDependent.putByte((long)(UnsafeAccess.directBufferAddress(buf) + (long)offset), (byte)b);
        } else {
            HBasePlatformDependent.putByte((Object)buf.array(), (long)(BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset() + (long)offset), (byte)b);
        }
        return offset + 1;
    }

    public static long directBufferAddress(ByteBuffer buf) {
        return PlatformDependent.directBufferAddress((ByteBuffer)buf);
    }

    public static void freeDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    static {
        LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        BYTE_ARRAY_BASE_OFFSET = HBasePlatformDependent.isUnsafeAvailable() ? (long)HBasePlatformDependent.arrayBaseOffset(byte[].class) : -1L;
    }
}

