/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.InputWriter;

public class TextInputWriter
extends InputWriter<Object, Object> {
    protected DataOutput clientOut;
    private byte[] inputSeparator;

    @Override
    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientOut = pipeMapRed.getClientOutput();
        this.inputSeparator = pipeMapRed.getInputSeparator();
    }

    @Override
    public void writeKey(Object key) throws IOException {
        this.writeUTF8(key);
        this.clientOut.write(this.inputSeparator);
    }

    @Override
    public void writeValue(Object value) throws IOException {
        this.writeUTF8(value);
        this.clientOut.write(10);
    }

    protected void writeUTF8(Object object) throws IOException {
        int valSize;
        byte[] bval;
        if (object instanceof BytesWritable) {
            BytesWritable val = (BytesWritable)object;
            bval = val.getBytes();
            valSize = val.getLength();
        } else if (object instanceof Text) {
            Text val = (Text)object;
            bval = val.getBytes();
            valSize = val.getLength();
        } else {
            String sval = object.toString();
            bval = sval.getBytes(StandardCharsets.UTF_8);
            valSize = bval.length;
        }
        this.clientOut.write(bval, 0, valSize);
    }
}

