/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.CharacterRing;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.integer.IntegerSolver;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.type.TypeUtils;

public final class OldIntegerSolver
extends IntegerSolver {
    private final Set<NodeKey> myExploredNodes = Collections.synchronizedSet(new HashSet());
    private final int[] myIntegerIndeces;

    OldIntegerSolver(ExpressionsBasedModel model, Optimisation.Options solverOptions) {
        super(model, solverOptions);
        List<Variable> tmpIntegerVariables = model.getIntegerVariables();
        this.myIntegerIndeces = new int[tmpIntegerVariables.size()];
        for (int i = 0; i < this.myIntegerIndeces.length; ++i) {
            Variable tmpVariable = tmpIntegerVariables.get(i);
            this.myIntegerIndeces[i] = model.indexOf(tmpVariable);
        }
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (kickStarter != null && kickStarter.getState().isFeasible() && this.getModel().validate(kickStarter)) {
            this.markInteger(null, kickStarter);
        }
        this.resetIterationsCount();
        BranchAndBoundNodeTask tmpNodeTask = new BranchAndBoundNodeTask();
        boolean tmpNormalExit = ForkJoinPool.commonPool().invoke(tmpNodeTask);
        Optimisation.Result retVal = this.getBestResultSoFar();
        retVal = retVal.getState().isFeasible() ? (tmpNormalExit ? new Optimisation.Result(Optimisation.State.OPTIMAL, retVal) : new Optimisation.Result(Optimisation.State.FEASIBLE, retVal)) : (tmpNormalExit ? new Optimisation.Result(Optimisation.State.INFEASIBLE, retVal) : new Optimisation.Result(Optimisation.State.FAILED, retVal));
        return retVal;
    }

    public String toString() {
        return TypeUtils.format("Solutions={} Nodes/Iterations={} {}", this.countIntegerSolutions(), this.countExploredNodes(), this.getBestResultSoFar());
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return (MatrixStore)PrimitiveDenseStore.FACTORY.columns(this.getBestResultSoFar());
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return !this.getState().isOptimal();
    }

    @Override
    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        try {
            retVal = this.getModel().validate();
            if (!retVal) {
                retVal = false;
                this.setState(Optimisation.State.INVALID);
            }
        }
        catch (Exception ex) {
            retVal = false;
            this.setState(Optimisation.State.FAILED);
        }
        return retVal;
    }

    int countExploredNodes() {
        return this.myExploredNodes.size();
    }

    int getGlobalIndex(int integerIndex) {
        return this.myIntegerIndeces[integerIndex];
    }

    final int[] getIntegerIndeces() {
        return this.myIntegerIndeces;
    }

    int identifyNonIntegerVariable(Optimisation.Result nodeResult, NodeKey nodeKey) {
        MatrixStore<Double> tmpGradient = this.getGradient(AccessUtils.asPrimitive1D(nodeResult));
        int retVal = -1;
        double tmpMaxFraction = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myIntegerIndeces.length; ++i) {
            double tmpFraction = nodeKey.getFraction(i, nodeResult.doubleValue(this.myIntegerIndeces[i]));
            double tmpWeightedFraction = tmpFraction * (PrimitiveMath.ONE + PrimitiveFunction.ABS.invoke(tmpGradient.doubleValue(this.myIntegerIndeces[i])));
            if (!(tmpWeightedFraction > tmpMaxFraction) || this.options.integer.isZero(tmpWeightedFraction)) continue;
            retVal = i;
            tmpMaxFraction = tmpWeightedFraction;
        }
        return retVal;
    }

    boolean isExplored(BranchAndBoundNodeTask aNodeTask) {
        return this.myExploredNodes.contains(aNodeTask.getKey());
    }

    void markAsExplored(BranchAndBoundNodeTask aNodeTask) {
        this.myExploredNodes.add(aNodeTask.getKey());
    }

    final class BranchAndBoundNodeTask
    extends RecursiveTask<Boolean> {
        private final NodeKey myKey;
        private final CharacterRing.PrinterBuffer myPrinter;

        private BranchAndBoundNodeTask(NodeKey key) {
            this.myPrinter = OldIntegerSolver.this.isDebug() ? new CharacterRing().asPrinter() : null;
            this.myKey = key;
        }

        BranchAndBoundNodeTask() {
            this.myPrinter = OldIntegerSolver.this.isDebug() ? new CharacterRing().asPrinter() : null;
            this.myKey = new NodeKey(OldIntegerSolver.this.getModel());
        }

        public String toString() {
            return this.myKey.toString();
        }

        private boolean isNodeDebug() {
            return this.myPrinter != null && OldIntegerSolver.this.isDebug();
        }

        @Override
        protected Boolean compute() {
            if (this.isNodeDebug()) {
                this.myPrinter.println("\nBranch&Bound Node");
                this.myPrinter.println(this.myKey.toString());
                this.myPrinter.println(OldIntegerSolver.this.toString());
            }
            if (!OldIntegerSolver.this.isIterationAllowed() || !OldIntegerSolver.this.isIterationNecessary()) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Reached iterations or time limit - stop!");
                    this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                }
                return false;
            }
            if (OldIntegerSolver.this.isExplored(this)) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Node previously explored!");
                    this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                }
                return true;
            }
            OldIntegerSolver.this.markAsExplored(this);
            if (!OldIntegerSolver.this.isGoodEnoughToContinueBranching(this.myKey.objective)) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("No longer a relevant node!");
                    this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                }
                return true;
            }
            ExpressionsBasedModel tmpNodeModel = this.getModel();
            Optimisation.Result tmpBestResultSoFar = OldIntegerSolver.this.getBestResultSoFar();
            Optimisation.Result tmpNodeResult = tmpNodeModel.solve(tmpBestResultSoFar);
            if (this.isNodeDebug()) {
                this.myPrinter.println("Node Result: {}", tmpNodeResult);
            }
            OldIntegerSolver.this.incrementIterationsCount();
            if (tmpNodeResult.getState().isOptimal()) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Node solved to optimality!");
                }
                if (OldIntegerSolver.this.options.validate && !tmpNodeModel.validate(tmpNodeResult)) {
                    this.myPrinter.println("Node solution marked as OPTIMAL, but is actually INVALID/INFEASIBLE/FAILED. Stop this branch!");
                    this.myPrinter.println("Lower bounds: {}", Arrays.toString(this.myKey.getLowerBounds()));
                    this.myPrinter.println("Upper bounds: {}", Arrays.toString(this.myKey.getUpperBounds()));
                    tmpNodeModel.validate((Access1D<BigDecimal>)tmpNodeResult, this.myPrinter);
                    this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                    return false;
                }
                int tmpBranchIndex = OldIntegerSolver.this.identifyNonIntegerVariable(tmpNodeResult, this.myKey);
                double tmpSolutionValue = OldIntegerSolver.this.evaluateFunction(tmpNodeResult);
                if (tmpBranchIndex == -1) {
                    if (this.isNodeDebug()) {
                        this.myPrinter.println("Integer solution! Store it among the others, and stop this branch!");
                    }
                    Optimisation.Result tmpIntegerSolutionResult = new Optimisation.Result(Optimisation.State.FEASIBLE, tmpSolutionValue, tmpNodeResult);
                    OldIntegerSolver.this.markInteger(this.myKey, tmpIntegerSolutionResult);
                    if (this.isNodeDebug()) {
                        this.myPrinter.println(OldIntegerSolver.this.getBestResultSoFar().toString());
                        BasicLogger.debug();
                        BasicLogger.debug(OldIntegerSolver.this.toString());
                        this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                    }
                } else {
                    if (this.isNodeDebug()) {
                        this.myPrinter.println("Not an Integer Solution: " + tmpSolutionValue);
                    }
                    double tmpVariableValue = tmpNodeResult.doubleValue(OldIntegerSolver.this.getGlobalIndex(tmpBranchIndex));
                    if (OldIntegerSolver.this.isGoodEnoughToContinueBranching(tmpSolutionValue)) {
                        if (this.isNodeDebug()) {
                            this.myPrinter.println("Still hope, branching on {} @ {} >>> {}", tmpBranchIndex, tmpVariableValue, tmpNodeModel.getVariable(OldIntegerSolver.this.getGlobalIndex(tmpBranchIndex)));
                            this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                        }
                        tmpNodeModel.dispose();
                        tmpNodeModel = null;
                        BranchAndBoundNodeTask tmpLowerBranchTask = this.createLowerBranch(tmpBranchIndex, tmpVariableValue, tmpSolutionValue);
                        BranchAndBoundNodeTask tmpUpperBranchTask = this.createUpperBranch(tmpBranchIndex, tmpVariableValue, tmpSolutionValue);
                        tmpUpperBranchTask.fork();
                        boolean tmpLowerBranchValue = tmpLowerBranchTask.compute();
                        boolean tmpUpperBranchValue = (Boolean)tmpUpperBranchTask.join();
                        return tmpLowerBranchValue & tmpUpperBranchValue;
                    }
                    if (this.isNodeDebug()) {
                        this.myPrinter.println("Can't find better integer solutions - stop this branch!");
                        this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
                    }
                }
            } else if (this.isNodeDebug()) {
                this.myPrinter.println("Failed to solve node problem - stop this branch!");
                this.flush(OldIntegerSolver.this.getModel().options.debug_appender);
            }
            return true;
        }

        BranchAndBoundNodeTask createLowerBranch(int branchIndex, double nonIntegerValue, double parentObjectiveValue) {
            NodeKey tmpKey = this.myKey.createLowerBranch(branchIndex, nonIntegerValue, parentObjectiveValue);
            return new BranchAndBoundNodeTask(tmpKey);
        }

        BranchAndBoundNodeTask createUpperBranch(int branchIndex, double nonIntegerValue, double parentObjectiveValue) {
            NodeKey tmpKey = this.myKey.createUpperBranch(branchIndex, nonIntegerValue, parentObjectiveValue);
            return new BranchAndBoundNodeTask(tmpKey);
        }

        void flush(BasicLogger.Printer receiver) {
            if (this.myPrinter != null && receiver != null) {
                this.myPrinter.flush(receiver);
            }
        }

        NodeKey getKey() {
            return this.myKey;
        }

        ExpressionsBasedModel getModel() {
            ExpressionsBasedModel retVal = OldIntegerSolver.this.getModel().relax(false);
            if (retVal.options.debug_appender != null) {
                retVal.options.debug_appender = new CharacterRing().asPrinter();
            }
            int[] tmpIntegerIndeces = OldIntegerSolver.this.getIntegerIndeces();
            for (int i = 0; i < tmpIntegerIndeces.length; ++i) {
                BigDecimal tmpLowerBound = this.myKey.getLowerBound(i);
                BigDecimal tmpUpperBound = this.myKey.getUpperBound(i);
                Variable tmpVariable = retVal.getVariable(tmpIntegerIndeces[i]);
                tmpVariable.lower(tmpLowerBound);
                tmpVariable.upper(tmpUpperBound);
                BigDecimal tmpValue = tmpVariable.getValue();
                if (tmpValue == null) continue;
                if (tmpLowerBound != null) {
                    tmpValue = tmpValue.max(tmpLowerBound);
                }
                if (tmpUpperBound != null) {
                    tmpValue = tmpValue.min(tmpUpperBound);
                }
                tmpVariable.setValue(tmpValue);
            }
            if (OldIntegerSolver.this.isIntegerSolutionFound()) {
                double tmpBestValue = OldIntegerSolver.this.getBestResultSoFar().getValue();
                double tmpGap = PrimitiveFunction.ABS.invoke(tmpBestValue * OldIntegerSolver.this.options.mip_gap);
                if (retVal.isMinimisation()) {
                    retVal.limitObjective(null, TypeUtils.toBigDecimal(tmpBestValue - tmpGap, OldIntegerSolver.this.options.problem));
                } else {
                    retVal.limitObjective(TypeUtils.toBigDecimal(tmpBestValue + tmpGap, OldIntegerSolver.this.options.problem), null);
                }
            }
            return retVal;
        }
    }
}

