/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import com.microsoft.azure.datalake.store.ADLException;
import com.microsoft.azure.datalake.store.ADLStoreClient;
import com.microsoft.azure.datalake.store.Core;
import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.OperationResponse;
import com.microsoft.azure.datalake.store.ReadBufferManager;
import com.microsoft.azure.datalake.store.RequestOptions;
import com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicy;
import com.microsoft.azure.datalake.store.retrypolicies.NoRetryPolicy;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLFileInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger((String)"com.microsoft.azure.datalake.store.ADLFileInputStream");
    private final String filename;
    private final ADLStoreClient client;
    private final DirectoryEntry directoryEntry;
    private final String sessionId = UUID.randomUUID().toString();
    private static final int defaultQueueDepth = 0;
    private int blocksize = 0x400000;
    private byte[] buffer = null;
    private int readAheadQueueDepth;
    private long fCursor = 0L;
    private int bCursor = 0;
    private int limit = 0;
    private boolean streamClosed = false;

    ADLFileInputStream(String filename, DirectoryEntry de, ADLStoreClient client) {
        this.filename = filename;
        this.client = client;
        this.directoryEntry = de;
        int requestedQD = client.getReadAheadQueueDepth();
        int n = this.readAheadQueueDepth = requestedQD >= 0 ? requestedQD : 0;
        if (log.isTraceEnabled()) {
            log.trace("ADLFIleInputStream created for client {} for file {}", (Object)client.getClientId(), (Object)filename);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int i = this.read(b, 0, 1);
        if (i < 0) {
            return i;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("null byte array passed in to read() method");
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.streamClosed) {
            throw new IOException("attempting to read from a closed stream");
        }
        if (b == null) {
            throw new IllegalArgumentException("null byte array passed in to read() method");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.read(b,off,{}) at offset {} using client {} from file {}", new Object[]{len, this.getPos(), this.client.getClientId(), this.filename});
        }
        if (len == 0) {
            return 0;
        }
        if (this.bCursor == this.limit && this.readFromService() < 0L) {
            return -1;
        }
        int bytesRemaining = this.limit - this.bCursor;
        int bytesToRead = Math.min(len, bytesRemaining);
        System.arraycopy(this.buffer, this.bCursor, b, off, bytesToRead);
        this.bCursor += bytesToRead;
        return bytesToRead;
    }

    protected long readFromService() throws IOException {
        if (this.bCursor < this.limit) {
            return 0L;
        }
        if (this.fCursor >= this.directoryEntry.length) {
            return -1L;
        }
        if (this.directoryEntry.length <= (long)this.blocksize) {
            return this.slurpFullFile();
        }
        this.bCursor = 0;
        this.limit = 0;
        if (this.buffer == null) {
            this.buffer = new byte[this.blocksize];
        }
        int bytesRead = this.readInternal(this.fCursor, this.buffer, 0, this.blocksize, false);
        this.limit += bytesRead;
        this.fCursor += (long)bytesRead;
        return bytesRead;
    }

    protected long slurpFullFile() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.slurpFullFile() - using client {} from file {}. At offset {}", new Object[]{this.client.getClientId(), this.filename, this.getPos()});
        }
        if (this.buffer == null) {
            this.blocksize = (int)this.directoryEntry.length;
            this.buffer = new byte[this.blocksize];
        }
        this.bCursor = (int)this.getPos();
        this.limit = 0;
        this.fCursor = 0L;
        int loopCount = 0;
        while (this.fCursor < this.directoryEntry.length) {
            int bytesRead = this.readInternal(this.fCursor, this.buffer, this.limit, this.blocksize - this.limit, true);
            this.limit += bytesRead;
            this.fCursor += (long)bytesRead;
            if (++loopCount < 10) continue;
            throw new IOException("Too many attempts in reading whole file " + this.filename);
        }
        return this.fCursor;
    }

    public int read(long position, byte[] b, int offset, int length) throws IOException {
        if (this.streamClosed) {
            throw new IOException("attempting to read from a closed stream");
        }
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream positioned read() - at offset {} using client {} from file {}", new Object[]{position, this.client.getClientId(), this.filename});
        }
        return this.readInternal(position, b, offset, length, true);
    }

    private int readInternal(long position, byte[] b, int offset, int length, boolean bypassReadAhead) throws IOException {
        boolean readAheadEnabled = true;
        if (readAheadEnabled && !bypassReadAhead && !this.client.disableReadAheads) {
            long nextSize;
            if (offset != 0) {
                throw new IllegalArgumentException("readahead buffers cannot have non-zero buffer offsets");
            }
            int numReadAheads = this.readAheadQueueDepth;
            for (long nextOffset = position; numReadAheads > 0 && nextOffset < this.directoryEntry.length; nextOffset += nextSize, --numReadAheads) {
                nextSize = Math.min((long)this.blocksize, this.directoryEntry.length - nextOffset);
                if (log.isTraceEnabled()) {
                    log.trace("Queueing readAhead for file " + this.filename + " offset " + nextOffset + " thread " + Thread.currentThread().getName());
                }
                ReadBufferManager.getBufferManager().queueReadAhead(this, nextOffset, (int)nextSize);
            }
            int receivedBytes = ReadBufferManager.getBufferManager().getBlock(this, position, length, b);
            if (receivedBytes > 0) {
                return receivedBytes;
            }
            receivedBytes = this.readRemote(position, b, offset, length, false);
            return receivedBytes;
        }
        return this.readRemote(position, b, offset, length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readRemote(long position, byte[] b, int offset, int length, boolean speculative) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("attempting to read from negative offset");
        }
        if (position >= this.directoryEntry.length) {
            return -1;
        }
        if (b == null) {
            throw new IllegalArgumentException("null byte array passed in to read() method");
        }
        if (offset >= b.length) {
            throw new IllegalArgumentException("offset greater than length of array");
        }
        if (length < 0) {
            throw new IllegalArgumentException("requested read length is less than zero");
        }
        if (length > b.length - offset) {
            throw new IllegalArgumentException("requested read length is more than will fit after requested offset in buffer");
        }
        int totalBytesRead = 0;
        int retriesRemaining = 1;
        while (retriesRemaining >= 0) {
            long start;
            OperationResponse resp;
            RequestOptions opts;
            block23: {
                byte[] junkbuffer = new byte[16384];
                opts = new RequestOptions();
                opts.retryPolicy = speculative ? new NoRetryPolicy() : new ExponentialBackoffPolicy();
                opts.timeout = this.client.timeout + 1000 * (length / 1000 / 1000);
                resp = new OperationResponse();
                InputStream inStream = Core.open(this.filename, position, length, this.sessionId, speculative, this.client, opts, resp);
                if (speculative && !resp.successful && resp.httpResponseCode == 400 && resp.remoteExceptionName.equals("SpeculativeReadNotSupported")) {
                    this.client.disableReadAheads = true;
                    return 0;
                }
                if (!resp.successful) {
                    throw this.client.getExceptionFromResponse(resp, "Error reading from file " + this.filename);
                }
                if (resp.responseContentLength == 0L && !resp.responseChunked) {
                    return 0;
                }
                start = System.nanoTime();
                try {
                    int bytesRead;
                    do {
                        if ((bytesRead = inStream.read(b, offset + totalBytesRead, length - totalBytesRead)) <= 0) continue;
                        totalBytesRead += bytesRead;
                    } while (bytesRead >= 0 && totalBytesRead < length);
                    if (bytesRead >= 0) {
                        while (inStream.read(junkbuffer, 0, junkbuffer.length) >= 0) {
                        }
                    }
                    if (inStream == null) break block23;
                }
                catch (IOException ex) {
                    block26: {
                        block24: {
                            int n;
                            block25: {
                                try {
                                    inStream.close();
                                    if (totalBytesRead <= 0) break block24;
                                    n = totalBytesRead;
                                    if (inStream == null) break block25;
                                }
                                catch (Throwable throwable) {
                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    long timeTaken = (System.nanoTime() - start) / 1000000L;
                                    if (log.isDebugEnabled()) {
                                        String logline = "HTTPRequestRead," + (resp.successful ? "Succeeded" : "Failed") + ",cReqId:" + opts.requestid + ",lat:" + Long.toString(resp.lastCallLatency + timeTaken) + ",Reqlen:" + totalBytesRead + ",sReqId:" + resp.requestId + ",path:" + this.filename + ",offset:" + position;
                                        log.debug(logline);
                                    }
                                    throw throwable;
                                }
                                inStream.close();
                            }
                            long timeTaken = (System.nanoTime() - start) / 1000000L;
                            if (log.isDebugEnabled()) {
                                String logline = "HTTPRequestRead," + (resp.successful ? "Succeeded" : "Failed") + ",cReqId:" + opts.requestid + ",lat:" + Long.toString(resp.lastCallLatency + timeTaken) + ",Reqlen:" + totalBytesRead + ",sReqId:" + resp.requestId + ",path:" + this.filename + ",offset:" + position;
                                log.debug(logline);
                            }
                            return n;
                        }
                        if (retriesRemaining == 0) {
                            throw new ADLException("Error reading data from response stream in positioned read() for file " + this.filename, ex);
                        }
                        --retriesRemaining;
                        if (inStream == null) break block26;
                        inStream.close();
                    }
                    long timeTaken = (System.nanoTime() - start) / 1000000L;
                    if (!log.isDebugEnabled()) continue;
                    String logline = "HTTPRequestRead," + (resp.successful ? "Succeeded" : "Failed") + ",cReqId:" + opts.requestid + ",lat:" + Long.toString(resp.lastCallLatency + timeTaken) + ",Reqlen:" + totalBytesRead + ",sReqId:" + resp.requestId + ",path:" + this.filename + ",offset:" + position;
                    log.debug(logline);
                    continue;
                }
                inStream.close();
            }
            long timeTaken = (System.nanoTime() - start) / 1000000L;
            if (log.isDebugEnabled()) {
                String logline = "HTTPRequestRead," + (resp.successful ? "Succeeded" : "Failed") + ",cReqId:" + opts.requestid + ",lat:" + Long.toString(resp.lastCallLatency + timeTaken) + ",Reqlen:" + totalBytesRead + ",sReqId:" + resp.requestId + ",path:" + this.filename + ",offset:" + position;
                log.debug(logline);
            }
            return totalBytesRead;
        }
        return totalBytesRead;
    }

    public void seek(long n) throws IOException, EOFException {
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.seek({}) using client {} for file {}", new Object[]{n, this.client.getClientId(), this.filename});
        }
        if (this.streamClosed) {
            throw new IOException("attempting to seek into a closed stream;");
        }
        if (n < 0L) {
            throw new EOFException("Cannot seek to before the beginning of file");
        }
        if (n > this.directoryEntry.length) {
            throw new EOFException("Cannot seek past end of file");
        }
        if (n >= this.fCursor - (long)this.limit && n <= this.fCursor) {
            this.bCursor = (int)(n - (this.fCursor - (long)this.limit));
            return;
        }
        this.fCursor = n;
        this.limit = 0;
        this.bCursor = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.skip({}) using client {} for file {}", new Object[]{n, this.client.getClientId(), this.filename});
        }
        if (this.streamClosed) {
            throw new IOException("attempting to skip() on a closed stream");
        }
        long currentPos = this.getPos();
        long newPos = currentPos + n;
        if (newPos < 0L) {
            newPos = 0L;
            n = newPos - currentPos;
        }
        if (newPos > this.directoryEntry.length) {
            newPos = this.directoryEntry.length;
            n = newPos - currentPos;
        }
        this.seek(newPos);
        return n;
    }

    public void setBufferSize(int newSize) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.setBufferSize({}) using client {} for file {}", new Object[]{newSize, this.client.getClientId(), this.filename});
        }
        if (newSize <= 0) {
            throw new IllegalArgumentException("Buffer size cannot be zero or less: " + newSize);
        }
        if (newSize == this.blocksize) {
            return;
        }
        this.unbuffer();
        this.blocksize = newSize;
        this.buffer = null;
    }

    public void setReadAheadQueueDepth(int queueDepth) {
        if (queueDepth < 0) {
            throw new IllegalArgumentException("Queue depth has to be 0 or more");
        }
        this.readAheadQueueDepth = queueDepth;
    }

    @Override
    public int available() throws IOException {
        if (this.streamClosed) {
            throw new IOException("attempting to call available() on a closed stream");
        }
        return this.limit - this.bCursor;
    }

    public long length() throws IOException {
        if (this.streamClosed) {
            throw new IOException("attempting to call length() on a closed stream");
        }
        return this.directoryEntry.length;
    }

    public long getPos() throws IOException {
        if (this.streamClosed) {
            throw new IOException("attempting to call getPos() on a closed stream");
        }
        return this.fCursor - (long)this.limit + (long)this.bCursor;
    }

    public void unbuffer() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.unbuffer() for client {} for file {}", (Object)this.client.getClientId(), (Object)this.filename);
        }
        this.fCursor = this.getPos();
        this.limit = 0;
        this.bCursor = 0;
    }

    @Override
    public void close() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("ADLFileInputStream.close() for client {} for file {}", (Object)this.client.getClientId(), (Object)this.filename);
        }
        this.streamClosed = true;
        this.buffer = null;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark()/reset() not supported on this stream");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("mark()/reset() not supported on this stream");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

