/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdTokenType;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "name", "type", "present", "required", "value"})
class RntbdToken {
    private static final int HEADER_LENGTH = 3;
    private final RntbdConstants.RntbdHeader header;
    private int length;
    private Object value;

    private RntbdToken(RntbdConstants.RntbdHeader header) {
        Objects.requireNonNull(header);
        this.header = header;
        this.value = null;
        this.length = Integer.MIN_VALUE;
    }

    @JsonProperty
    RntbdTokenType getType() {
        return this.header.type();
    }

    @JsonProperty
    final short getId() {
        return this.header.id();
    }

    @JsonProperty
    final String getName() {
        return this.header.name();
    }

    @JsonProperty
    final Object getValue() {
        if (this.value == null) {
            return this.header.type().codec().defaultValue();
        }
        if (this.value instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)this.value;
            this.value = this.header.type().codec().read(buffer);
            buffer.release();
        } else {
            this.value = this.header.type().codec().convert(this.value);
        }
        return this.value;
    }

    final int computeLength() {
        if (!this.isPresent()) {
            return 0;
        }
        if (this.value instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)this.value;
            assert (buffer.readerIndex() == 0);
            return 3 + buffer.readableBytes();
        }
        if (this.length == Integer.MIN_VALUE) {
            this.length = 3 + this.header.type().codec().computeLength(this.value);
        }
        return this.length;
    }

    @JsonProperty
    final void setValue(Object value) {
        this.ensureValid(value);
        this.length = Integer.MIN_VALUE;
        this.value = value;
    }

    @JsonProperty
    final boolean isPresent() {
        return this.value != null;
    }

    @JsonProperty
    final boolean isRequired() {
        return this.header.isRequired();
    }

    static RntbdToken create(RntbdConstants.RntbdHeader header) {
        return new RntbdToken(header);
    }

    void decode(ByteBuf in) {
        Objects.requireNonNull(in);
        if (this.value instanceof ByteBuf) {
            ((ByteBuf)this.value).release();
        }
        this.value = this.header.type().codec().readSlice(in).retain();
    }

    final void encode(ByteBuf out) {
        Objects.requireNonNull(out);
        if (!this.isPresent()) {
            if (this.isRequired()) {
                String message = String.format("Missing value for required header: %s", this);
                throw new IllegalStateException(message);
            }
            return;
        }
        out.writeShortLE((int)this.getId());
        out.writeByte((int)this.getType().id());
        if (this.value instanceof ByteBuf) {
            out.writeBytes((ByteBuf)this.value);
        } else {
            this.ensureValid(this.value);
            this.header.type().codec().write(this.value, out);
        }
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    final <T> T getValue(Class<T> cls) {
        return cls.cast(this.getValue());
    }

    final void releaseBuffer() {
        if (this.value instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)this.value;
            buffer.release();
        }
    }

    private void ensureValid(Object value) {
        Objects.requireNonNull(value);
        if (!this.header.type().codec().isValid(value)) {
            String reason = String.format("value: %s", value.getClass());
            throw new IllegalArgumentException(reason);
        }
    }

    static {
        RntbdObjectMapper.registerPropertyFilter(RntbdToken.class, PropertyFilter.class);
    }

    static class PropertyFilter
    extends SimpleBeanPropertyFilter {
        PropertyFilter() {
        }

        public void serializeAsField(Object object, JsonGenerator generator, SerializerProvider provider, PropertyWriter writer) throws Exception {
            Object value;
            if (generator.canOmitFields() && (value = writer.getMember().getValue(object)) instanceof RntbdToken && !((RntbdToken)value).isPresent()) {
                return;
            }
            writer.serializeAsField(object, generator, provider);
        }
    }
}

