/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.security.token;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.security.token.ZKDelegationTokenSecretManagerImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.TestZKDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKDelegationTokenSecretManagerImpl
extends TestZKDelegationTokenSecretManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestZKDelegationTokenSecretManagerImpl.class);

    @Test
    public void testMultiNodeOperationWithoutWatch() throws Exception {
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        conf.setBoolean("zk-dt-secret-manager.token.watcher.enabled", false);
        conf.setInt("zk-dt-secret-manager.router.token.sync.interval", 3);
        for (int i = 0; i < 2; ++i) {
            ZKDelegationTokenSecretManagerImpl dtsm1 = new ZKDelegationTokenSecretManagerImpl(conf);
            ZKDelegationTokenSecretManagerImpl dtsm2 = new ZKDelegationTokenSecretManagerImpl(conf);
            DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
            tm1.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm1);
            DelegationTokenManager tm2 = new DelegationTokenManager(conf, new Text("bla"));
            tm2.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm2);
            Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token);
            tm2.verifyToken(token);
            tm2.renewToken(token, "foo");
            tm1.verifyToken(token);
            tm1.cancelToken(token, "foo");
            try {
                this.verifyTokenFail(tm2, token);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken invalidToken) {
                // empty catch block
            }
            token = tm2.createToken(UserGroupInformation.getCurrentUser(), "bar");
            Assert.assertNotNull((Object)token);
            tm1.verifyToken(token);
            tm1.renewToken(token, "bar");
            tm2.verifyToken(token);
            tm2.cancelToken(token, "bar");
            try {
                this.verifyTokenFail(tm1, token);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken invalidToken) {
                // empty catch block
            }
            dtsm1.stopThreads();
            dtsm2.stopThreads();
            this.verifyDestroy(tm1, conf);
            this.verifyDestroy(tm2, conf);
        }
    }

    @Test
    public void testMultiNodeTokenRemovalShortSyncWithoutWatch() throws Exception {
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        conf.setBoolean("zk-dt-secret-manager.token.watcher.enabled", false);
        conf.setInt("zk-dt-secret-manager.router.token.sync.interval", 3);
        conf.setInt("delegation-token.renew-interval.sec", 10);
        conf.setInt("delegation-token.removal-scan-interval.sec", 10);
        for (int i = 0; i < 2; ++i) {
            ZKDelegationTokenSecretManagerImpl dtsm1 = new ZKDelegationTokenSecretManagerImpl(conf);
            ZKDelegationTokenSecretManagerImpl dtsm2 = new ZKDelegationTokenSecretManagerImpl(conf);
            DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
            tm1.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm1);
            DelegationTokenManager tm2 = new DelegationTokenManager(conf, new Text("bla"));
            tm2.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm2);
            Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token);
            tm2.verifyToken(token);
            Thread.sleep(9000L);
            tm2.renewToken(token, "foo");
            tm1.verifyToken(token);
            Thread.sleep(4000L);
            tm1.verifyToken(token);
            tm2.verifyToken(token);
            dtsm1.stopThreads();
            dtsm2.stopThreads();
            this.verifyDestroy(tm1, conf);
            this.verifyDestroy(tm2, conf);
        }
    }

    @Test
    public void testMultiNodeTokenRemovalLongSyncWithoutWatch() throws Exception {
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        conf.setBoolean("zk-dt-secret-manager.token.watcher.enabled", false);
        conf.setInt("zk-dt-secret-manager.router.token.sync.interval", 20);
        conf.setInt("delegation-token.renew-interval.sec", 10);
        conf.setInt("delegation-token.removal-scan-interval.sec", 10);
        for (int i = 0; i < 2; ++i) {
            ZKDelegationTokenSecretManagerImpl dtsm1 = new ZKDelegationTokenSecretManagerImpl(conf);
            ZKDelegationTokenSecretManagerImpl dtsm2 = new ZKDelegationTokenSecretManagerImpl(conf);
            ZKDelegationTokenSecretManagerImpl dtsm3 = new ZKDelegationTokenSecretManagerImpl(conf);
            DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
            tm1.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm1);
            DelegationTokenManager tm2 = new DelegationTokenManager(conf, new Text("bla"));
            tm2.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm2);
            DelegationTokenManager tm3 = new DelegationTokenManager(conf, new Text("bla"));
            tm3.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)dtsm3);
            Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token);
            tm2.verifyToken(token);
            Thread.sleep(9000L);
            long renewalTime = tm2.renewToken(token, "foo");
            LOG.info("Renew for token {} at current time {} renewal time {}", new Object[]{token.getIdentifier(), Time.formatTime((long)Time.now()), Time.formatTime((long)renewalTime)});
            tm1.verifyToken(token);
            Thread.sleep(4000L);
            tm2.verifyToken(token);
            tm3.verifyToken(token);
            dtsm1.stopThreads();
            dtsm2.stopThreads();
            dtsm3.stopThreads();
            this.verifyDestroy(tm1, conf);
            this.verifyDestroy(tm2, conf);
            this.verifyDestroy(tm3, conf);
        }
    }
}

