/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.oncrpc.XDR;

public class WRITE3Request
extends RequestWithHandle {
    private long offset;
    private int count;
    private final Nfs3Constant.WriteStableHow stableHow;
    private final ByteBuffer data;

    public static WRITE3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = WRITE3Request.readHandle(xdr);
        long offset = xdr.readHyper();
        int count = xdr.readInt();
        Nfs3Constant.WriteStableHow stableHow = Nfs3Constant.WriteStableHow.fromValue(xdr.readInt());
        ByteBuffer data = ByteBuffer.wrap(xdr.readFixedOpaque(xdr.readInt()));
        return new WRITE3Request(handle, offset, count, stableHow, data);
    }

    public WRITE3Request(FileHandle handle, long offset, int count, Nfs3Constant.WriteStableHow stableHow, ByteBuffer data) {
        super(handle);
        this.offset = offset;
        this.count = count;
        this.stableHow = stableHow;
        this.data = data;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Nfs3Constant.WriteStableHow getStableHow() {
        return this.stableHow;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeLongAsHyper(this.offset);
        xdr.writeInt(this.count);
        xdr.writeInt(this.stableHow.getValue());
        xdr.writeInt(this.count);
        xdr.writeFixedOpaque(this.data.array(), this.count);
    }

    public String toString() {
        return String.format("fileHandle: %s offset: %d count: %d stableHow: %s", this.handle.dumpFileHandle(), this.offset, this.count, this.stableHow.name());
    }
}

