/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPathData {
    private static final String TEST_ROOT_DIR = GenericTestUtils.getTestDir("testPD").getAbsolutePath();
    protected Configuration conf;
    protected FileSystem fs;
    protected Path testDir;

    @Before
    public void initialize() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new Path(TEST_ROOT_DIR);
        this.testDir = new Path(this.fs.makeQualified(this.testDir).toUri().getPath());
        this.fs.mkdirs(this.testDir);
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fs.getUri());
        this.fs.setWorkingDirectory(this.testDir);
        this.fs.mkdirs(new Path("d1"));
        this.fs.createNewFile(new Path("d1", "f1"));
        this.fs.createNewFile(new Path("d1", "f1.1"));
        this.fs.createNewFile(new Path("d1", "f2"));
        this.fs.mkdirs(new Path("d2"));
        this.fs.create(new Path("d2", "f3"));
    }

    @After
    public void cleanup() throws Exception {
        this.fs.delete(this.testDir, true);
        this.fs.close();
    }

    @Test(timeout=30000L)
    public void testWithDirStringAndConf() throws Exception {
        String dirString = "d1";
        PathData item = new PathData(dirString, this.conf);
        this.checkPathData(dirString, item);
        dirString = "d1/";
        item = new PathData(dirString, this.conf);
        this.checkPathData(dirString, item);
    }

    @Test(timeout=30000L)
    public void testUnqualifiedUriContents() throws Exception {
        String dirString = "d1";
        PathData item = new PathData(dirString, this.conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString("d1/f1", "d1/f1.1", "d1/f2"), (Object)TestPathData.sortedString(items));
    }

    @Test(timeout=30000L)
    public void testQualifiedUriContents() throws Exception {
        String dirString = this.fs.makeQualified(new Path("d1")).toString();
        PathData item = new PathData(dirString, this.conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString(dirString + "/f1", dirString + "/f1.1", dirString + "/f2"), (Object)TestPathData.sortedString(items));
    }

    @Test(timeout=30000L)
    public void testCwdContents() throws Exception {
        String dirString = ".";
        PathData item = new PathData(dirString, this.conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString("d1", "d2"), (Object)TestPathData.sortedString(items));
    }

    @Test(timeout=30000L)
    public void testToFile() throws Exception {
        PathData item = new PathData(".", this.conf);
        Assert.assertEquals((Object)new File(this.testDir.toString()), (Object)item.toFile());
        item = new PathData("d1/f1", this.conf);
        Assert.assertEquals((Object)new File(this.testDir + "/d1/f1"), (Object)item.toFile());
        item = new PathData(this.testDir + "/d1/f1", this.conf);
        Assert.assertEquals((Object)new File(this.testDir + "/d1/f1"), (Object)item.toFile());
    }

    @Test(timeout=5000L)
    public void testToFileRawWindowsPaths() throws Exception {
        PathData item;
        String[] winPaths;
        PlatformAssumptions.assumeWindows();
        for (String path : winPaths = new String[]{"n:\\", "N:\\", "N:\\foo", "N:\\foo\\bar", "N:/", "N:/foo", "N:/foo/bar"}) {
            item = new PathData(path, this.conf);
            Assert.assertEquals((Object)new File(path), (Object)item.toFile());
        }
        item = new PathData("foo\\bar", this.conf);
        Assert.assertEquals((Object)new File(this.testDir + "\\foo\\bar"), (Object)item.toFile());
    }

    @Test(timeout=5000L)
    public void testInvalidWindowsPath() throws Exception {
        String[] winPaths;
        PlatformAssumptions.assumeWindows();
        for (String path : winPaths = new String[]{"N:\\foo/bar"}) {
            try {
                PathData item = new PathData(path, this.conf);
                Assert.fail((String)("Did not throw for invalid path " + path));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test(timeout=30000L)
    public void testAbsoluteGlob() throws Exception {
        PathData[] items = PathData.expandAsGlob((String)(this.testDir + "/d1/f1*"), (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString(this.testDir + "/d1/f1", this.testDir + "/d1/f1.1"), (Object)TestPathData.sortedString(items));
        String absolutePathNoDriveLetter = this.testDir + "/d1/f1";
        if (Shell.WINDOWS) {
            absolutePathNoDriveLetter = absolutePathNoDriveLetter.substring(2);
        }
        items = PathData.expandAsGlob((String)absolutePathNoDriveLetter, (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString(absolutePathNoDriveLetter), (Object)TestPathData.sortedString(items));
        items = PathData.expandAsGlob((String)".", (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString("."), (Object)TestPathData.sortedString(items));
    }

    @Test(timeout=30000L)
    public void testRelativeGlob() throws Exception {
        PathData[] items = PathData.expandAsGlob((String)"d1/f1*", (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString("d1/f1", "d1/f1.1"), (Object)TestPathData.sortedString(items));
    }

    @Test(timeout=30000L)
    public void testRelativeGlobBack() throws Exception {
        this.fs.setWorkingDirectory(new Path("d1"));
        PathData[] items = PathData.expandAsGlob((String)"../d2/*", (Configuration)this.conf);
        Assert.assertEquals((Object)TestPathData.sortedString("../d2/f3"), (Object)TestPathData.sortedString(items));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobThrowsExceptionForUnreadableDir() throws Exception {
        Path obscuredDir = new Path("foo");
        Path subDir = new Path(obscuredDir, "bar");
        this.fs.mkdirs(subDir);
        this.fs.setPermission(obscuredDir, new FsPermission(0));
        try {
            PathData.expandAsGlob((String)"foo/*", (Configuration)this.conf);
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
        }
        finally {
            this.fs.setPermission(obscuredDir, new FsPermission(493));
        }
    }

    @Test(timeout=30000L)
    public void testWithStringAndConfForBuggyPath() throws Exception {
        String dirString = "file:///tmp";
        Path tmpDir = new Path(dirString);
        PathData item = new PathData(dirString, this.conf);
        Assert.assertEquals((Object)"file:/tmp", (Object)tmpDir.toString());
        this.checkPathData(dirString, item);
    }

    public void checkPathData(String dirString, PathData item) throws Exception {
        Assert.assertEquals((String)"checking fs", (Object)this.fs, (Object)item.fs);
        Assert.assertEquals((String)"checking string", (Object)dirString, (Object)item.toString());
        Assert.assertEquals((String)"checking path", (Object)this.fs.makeQualified(new Path(item.toString())), (Object)item.path);
        Assert.assertTrue((String)"checking exist", (item.stat != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"checking isDir", (boolean)item.stat.isDirectory());
    }

    private static String sortedString(Object ... list) {
        Object[] strings = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            strings[i] = String.valueOf(list[i]);
        }
        Arrays.sort(strings);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(i + ":<" + (String)strings[i] + ">");
        }
        return result.toString();
    }

    private static String sortedString(PathData ... items) {
        return TestPathData.sortedString((Object[])items);
    }
}

