/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi;

import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.Volume;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeImpl;
import org.apache.hadoop.yarn.server.volume.csi.VolumeCapabilityRange;
import org.apache.hadoop.yarn.server.volume.csi.VolumeId;
import org.apache.hadoop.yarn.server.volume.csi.VolumeMetaData;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;

public final class VolumeBuilder {
    private String id;
    private String name;
    private Long min;
    private Long max;
    private String unit;
    private String driver;
    private String mount;

    private VolumeBuilder() {
    }

    public static VolumeBuilder newBuilder() {
        return new VolumeBuilder();
    }

    public VolumeBuilder volumeId(String volumeId) {
        this.id = volumeId;
        return this;
    }

    public VolumeBuilder volumeName(String volumeName) {
        this.name = volumeName;
        return this;
    }

    public VolumeBuilder minCapability(long minCapability) {
        this.min = minCapability;
        return this;
    }

    public VolumeBuilder maxCapability(long maxCapability) {
        this.max = maxCapability;
        return this;
    }

    public VolumeBuilder unit(String capUnit) {
        this.unit = capUnit;
        return this;
    }

    public VolumeBuilder driverName(String driverName) {
        this.driver = driverName;
        return this;
    }

    public VolumeBuilder mountPoint(String mountPoint) {
        this.mount = mountPoint;
        return this;
    }

    public Volume build() throws InvalidVolumeException {
        VolumeId vid = new VolumeId(Optional.ofNullable(this.id).orElse(UUID.randomUUID().toString()));
        VolumeCapabilityRange volumeCap = VolumeCapabilityRange.newBuilder().minCapacity(Optional.ofNullable(this.min).orElse(0L)).maxCapacity(Optional.ofNullable(this.max).orElse(Long.MAX_VALUE)).unit(Optional.ofNullable(this.unit).orElse("Gi")).build();
        VolumeMetaData meta = VolumeMetaData.newBuilder().capability(volumeCap).driverName(Optional.ofNullable(this.driver).orElse("test-driver")).mountPoint(Optional.ofNullable(this.mount).orElse("/mnt/data")).volumeName(this.name).volumeId(vid).build();
        return new VolumeImpl(meta);
    }
}

