/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.AliasMapProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.AliasMapProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.InMemoryAliasMapFailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.shaded.javax.websocket.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryAliasMapProtocolClientSideTranslatorPB
implements InMemoryAliasMapProtocol,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryAliasMapProtocolClientSideTranslatorPB.class);
    private AliasMapProtocolPB rpcProxy;

    public InMemoryAliasMapProtocolClientSideTranslatorPB(AliasMapProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    public static Collection<InMemoryAliasMapProtocol> init(Configuration conf) {
        ArrayList<InMemoryAliasMapProtocol> aliasMaps = new ArrayList<InMemoryAliasMapProtocol>();
        for (String nsId : DFSUtilClient.getNameServiceIds((Configuration)conf)) {
            try {
                URI namenodeURI = null;
                Configuration newConf = new Configuration(conf);
                if (HAUtil.isHAEnabled(conf, nsId)) {
                    newConf.setClass(DFSUtil.addKeySuffixes("dfs.client.failover.proxy.provider", nsId), InMemoryAliasMapFailoverProxyProvider.class, AbstractNNFailoverProxyProvider.class);
                    namenodeURI = new URI("hdfs://" + nsId);
                } else {
                    String key = DFSUtil.addKeySuffixes("dfs.provided.aliasmap.inmemory.dnrpc-address", nsId);
                    String addr = conf.get(key);
                    if (addr != null) {
                        namenodeURI = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
                    }
                }
                if (namenodeURI == null) continue;
                aliasMaps.add((InMemoryAliasMapProtocol)NameNodeProxies.createProxy(newConf, namenodeURI, InMemoryAliasMapProtocol.class).getProxy());
                LOG.info("Connected to InMemoryAliasMap at {}", (Object)namenodeURI);
            }
            catch (IOException | URISyntaxException e) {
                LOG.warn("Exception in connecting to InMemoryAliasMap for nameservice {}: {}", (Object)nsId, (Object)e);
            }
        }
        if (conf.get("dfs.provided.aliasmap.inmemory.dnrpc-address") != null) {
            URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)conf.get("dfs.provided.aliasmap.inmemory.dnrpc-address")));
            try {
                aliasMaps.add((InMemoryAliasMapProtocol)NameNodeProxies.createProxy(conf, uri, InMemoryAliasMapProtocol.class).getProxy());
                LOG.info("Connected to InMemoryAliasMap at {}", (Object)uri);
            }
            catch (IOException e) {
                LOG.warn("Exception in connecting to InMemoryAliasMap at {}: {}", (Object)uri, (Object)e);
            }
        }
        return aliasMaps;
    }

    @Override
    public InMemoryAliasMapProtocol.IterationResult list(Optional<Block> marker) throws IOException {
        AliasMapProtocolProtos.ListRequestProto.Builder builder = AliasMapProtocolProtos.ListRequestProto.newBuilder();
        if (marker.isPresent()) {
            builder.setMarker(PBHelperClient.convert((Block)marker.get()));
        }
        AliasMapProtocolProtos.ListRequestProto request = builder.build();
        AliasMapProtocolProtos.ListResponseProto response = (AliasMapProtocolProtos.ListResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.list(null, request));
        List<AliasMapProtocolProtos.KeyValueProto> fileRegionsList = response.getFileRegionsList();
        List<FileRegion> fileRegions = fileRegionsList.stream().map(kv -> new FileRegion(PBHelperClient.convert((HdfsProtos.BlockProto)kv.getKey()), PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)kv.getValue()))).collect(Collectors.toList());
        HdfsProtos.BlockProto nextMarker = response.getNextMarker();
        if (nextMarker.isInitialized()) {
            return new InMemoryAliasMapProtocol.IterationResult(fileRegions, Optional.of(PBHelperClient.convert((HdfsProtos.BlockProto)nextMarker)));
        }
        return new InMemoryAliasMapProtocol.IterationResult(fileRegions, Optional.empty());
    }

    @Override
    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block block) throws IOException {
        if (block == null) {
            throw new IOException("Block cannot be null");
        }
        AliasMapProtocolProtos.ReadRequestProto request = AliasMapProtocolProtos.ReadRequestProto.newBuilder().setKey(PBHelperClient.convert((Block)block)).build();
        AliasMapProtocolProtos.ReadResponseProto response = (AliasMapProtocolProtos.ReadResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.read(null, request));
        HdfsProtos.ProvidedStorageLocationProto providedStorageLocation = response.getValue();
        if (providedStorageLocation.isInitialized()) {
            return Optional.of(PBHelperClient.convert((HdfsProtos.ProvidedStorageLocationProto)providedStorageLocation));
        }
        return Optional.empty();
    }

    @Override
    public void write(@Nonnull Block block, @Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        if (block == null || providedStorageLocation == null) {
            throw new IOException("Provided block and location cannot be null");
        }
        AliasMapProtocolProtos.WriteRequestProto request = AliasMapProtocolProtos.WriteRequestProto.newBuilder().setKeyValuePair(AliasMapProtocolProtos.KeyValueProto.newBuilder().setKey(PBHelperClient.convert((Block)block)).setValue(PBHelperClient.convert((ProvidedStorageLocation)providedStorageLocation)).build()).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.write(null, request));
    }

    @Override
    public String getBlockPoolId() throws IOException {
        AliasMapProtocolProtos.BlockPoolResponseProto response = (AliasMapProtocolProtos.BlockPoolResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBlockPoolId(null, AliasMapProtocolProtos.BlockPoolRequestProto.newBuilder().build()));
        return response.getBlockPoolId();
    }

    @Override
    public void close() throws IOException {
        LOG.info("Stopping rpcProxy inInMemoryAliasMapProtocolClientSideTranslatorPB");
        if (this.rpcProxy != null) {
            RPC.stopProxy((Object)this.rpcProxy);
        }
    }
}

