/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationWeight;

class RouletteSelector {
    private Random picker;

    RouletteSelector(Random rnd) {
        this.picker = rnd;
    }

    Operation select(List<OperationWeight> ops) {
        if (ops.isEmpty()) {
            return null;
        }
        double totalWeight = 0.0;
        for (OperationWeight w : ops) {
            if (w.getWeight() < 0.0) {
                throw new IllegalArgumentException("Negative weights not allowed");
            }
            totalWeight += w.getWeight();
        }
        double sAm = this.picker.nextDouble() * totalWeight;
        int index = 0;
        for (int i = 0; i < ops.size(); ++i) {
            if (!((sAm -= ops.get(i).getWeight()) <= 0.0)) continue;
            index = i;
            break;
        }
        return ops.get(index).getOperation();
    }
}

