/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.AggregateDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContextBase;
import com.microsoft.azure.cosmosdb.rx.internal.query.TakeContinuationToken;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import rx.Observable;
import rx.functions.Func1;

public class TopDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private final IDocumentQueryExecutionComponent<T> component;
    private final int top;

    public TopDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int top) {
        this.component = component;
        this.top = top;
    }

    public static <T extends Resource> Observable<IDocumentQueryExecutionComponent<T>> createAsync(Function<String, Observable<IDocumentQueryExecutionComponent<T>>> createSourceComponentFunction, int topCount, String topContinuationToken) {
        TakeContinuationToken takeContinuationToken;
        if (topContinuationToken == null) {
            takeContinuationToken = new TakeContinuationToken(topCount, null);
        } else {
            Utils.ValueHolder outTakeContinuationToken = new Utils.ValueHolder();
            if (!TakeContinuationToken.tryParse(topContinuationToken, (Utils.ValueHolder<TakeContinuationToken>)outTakeContinuationToken)) {
                String message = String.format("Invalid JSON in continuation token %s for Top~Context", topContinuationToken);
                DocumentClientException dce = new DocumentClientException(400, message);
                return Observable.error((Throwable)dce);
            }
            takeContinuationToken = (TakeContinuationToken)((Object)outTakeContinuationToken.v);
        }
        if (takeContinuationToken.getTakeCount() > topCount) {
            String message = String.format("top count in continuation token: %d can not be greater than the top count in the query: %d.", takeContinuationToken.getTakeCount(), topCount);
            DocumentClientException dce = new DocumentClientException(400, message);
            return Observable.error((Throwable)dce);
        }
        return createSourceComponentFunction.apply(takeContinuationToken.getSourceToken()).map(component -> new TopDocumentQueryExecutionContext(component, takeContinuationToken.getTakeCount()));
    }

    @Override
    public Observable<FeedResponse<T>> drainAsync(int maxPageSize) {
        ParallelDocumentQueryExecutionContextBase context = this.component instanceof AggregateDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((AggregateDocumentQueryExecutionContext)this.component).getComponent() : (ParallelDocumentQueryExecutionContextBase)this.component;
        context.setTop(this.top);
        return this.component.drainAsync(maxPageSize).takeUntil(new Func1<FeedResponse<T>, Boolean>(){
            private volatile int fetchedItems = 0;

            public Boolean call(FeedResponse<T> frp) {
                this.fetchedItems += frp.getResults().size();
                return this.fetchedItems >= TopDocumentQueryExecutionContext.this.top;
            }
        }).map(new Func1<FeedResponse<T>, FeedResponse<T>>(){
            private volatile int collectedItems = 0;
            private volatile boolean lastPage = false;

            public FeedResponse<T> call(FeedResponse<T> t) {
                if (this.collectedItems + t.getResults().size() <= TopDocumentQueryExecutionContext.this.top) {
                    this.collectedItems += t.getResults().size();
                    HashMap<String, String> headers = new HashMap<String, String>(t.getResponseHeaders());
                    if (TopDocumentQueryExecutionContext.this.top != this.collectedItems) {
                        String sourceContinuationToken = t.getResponseContinuation();
                        TakeContinuationToken takeContinuationToken = new TakeContinuationToken(TopDocumentQueryExecutionContext.this.top - this.collectedItems, sourceContinuationToken);
                        headers.put("x-ms-continuation", takeContinuationToken.toJson());
                    } else {
                        headers.put("x-ms-continuation", null);
                    }
                    return BridgeInternal.createFeedResponseWithQueryMetrics((List)t.getResults(), headers, (ConcurrentMap)t.getQueryMetrics());
                }
                assert (!this.lastPage);
                this.lastPage = true;
                int lastPageSize = TopDocumentQueryExecutionContext.this.top - this.collectedItems;
                this.collectedItems += lastPageSize;
                HashMap<String, Object> headers = new HashMap<String, Object>(t.getResponseHeaders());
                headers.put("x-ms-continuation", null);
                return BridgeInternal.createFeedResponseWithQueryMetrics(t.getResults().subList(0, lastPageSize), headers, (ConcurrentMap)t.getQueryMetrics());
            }
        });
    }
}

