/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.NodeUpdateSchedulerEventWrapper;
import org.apache.hadoop.yarn.sls.scheduler.RMNodeWrapper;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.Tracker;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSSchedulerCommons {
    private static final Logger LOG = LoggerFactory.getLogger(SLSSchedulerCommons.class);
    private final AbstractYarnScheduler<?, ?> scheduler;
    private boolean metricsON;
    private SchedulerMetrics schedulerMetrics;
    private final Map<ContainerId, Resource> preemptionContainerMap = new ConcurrentHashMap<ContainerId, Resource>();
    private final Map<ApplicationAttemptId, String> appQueueMap = new ConcurrentHashMap<ApplicationAttemptId, String>();
    private final Tracker tracker;

    public SLSSchedulerCommons(AbstractYarnScheduler<?, ?> scheduler) {
        this.scheduler = scheduler;
        this.tracker = new Tracker();
    }

    public void initMetrics(Class<? extends AbstractYarnScheduler<?, ?>> schedulerClass, Configuration conf) {
        this.metricsON = conf.getBoolean("yarn.sls.metrics.switch", true);
        if (this.metricsON) {
            try {
                this.schedulerMetrics = SchedulerMetrics.getInstance(conf, schedulerClass);
                this.schedulerMetrics.init((ResourceScheduler)this.scheduler, conf);
            }
            catch (Exception e) {
                LOG.error("Caught exception while initializing schedulerMetrics", (Throwable)e);
            }
        }
    }

    void stopMetrics() {
        try {
            if (this.metricsON) {
                this.schedulerMetrics.tearDown();
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception while stopping service", (Throwable)e);
        }
    }

    public Allocation allocate(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<SchedulingRequest> schedulingRequests, List<ContainerId> containerIds, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        if (this.metricsON) {
            Timer.Context context = this.schedulerMetrics.getSchedulerAllocateTimer().time();
            Allocation allocation = null;
            try {
                Allocation allocation2 = allocation = ((SchedulerWrapper)this.scheduler).allocatePropagated(attemptId, resourceRequests, schedulingRequests, containerIds, blacklistAdditions, blacklistRemovals, updateRequests);
                return allocation2;
            }
            catch (Exception e) {
                LOG.error("Caught exception from allocate", (Throwable)e);
                throw e;
            }
            finally {
                context.stop();
                this.schedulerMetrics.increaseSchedulerAllocationCounter();
                try {
                    this.updateQueueWithAllocateRequest(allocation, attemptId, resourceRequests, containerIds);
                }
                catch (IOException e) {
                    LOG.error("Caught exception while executing finally block", (Throwable)e);
                }
            }
        }
        return ((SchedulerWrapper)this.scheduler).allocatePropagated(attemptId, resourceRequests, schedulingRequests, containerIds, blacklistAdditions, blacklistRemovals, updateRequests);
    }

    private void updateQueueWithAllocateRequest(Allocation allocation, ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds) throws IOException {
        Resource pendingResource = Resources.createResource((int)0, (int)0);
        Resource allocatedResource = Resources.createResource((int)0, (int)0);
        String queueName = this.appQueueMap.get(attemptId);
        for (ResourceRequest request : resourceRequests) {
            if (!request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)pendingResource, (Resource)Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        for (Object container : allocation.getContainers()) {
            Resources.addTo((Resource)allocatedResource, (Resource)container.getResource());
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        SchedulerAppReport report = this.scheduler.getSchedulerAppInfo(attemptId);
        for (ContainerId containerId : containerIds) {
            Container container = null;
            for (RMContainer c : report.getLiveContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container != null) {
                Resources.subtractFrom((Resource)allocatedResource, (Resource)container.getResource());
                continue;
            }
            for (RMContainer c : report.getReservedContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container == null) continue;
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        HashSet preemptionContainers = new HashSet();
        if (allocation.getContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getContainerPreemptions());
        }
        if (allocation.getStrictContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getStrictContainerPreemptions());
        }
        if (!preemptionContainers.isEmpty()) {
            for (ContainerId containerId : preemptionContainers) {
                if (this.preemptionContainerMap.containsKey(containerId)) continue;
                Container container = null;
                for (RMContainer c : report.getLiveContainers()) {
                    if (!c.getContainerId().equals((Object)containerId)) continue;
                    container = c.getContainer();
                    break;
                }
                if (container == null) continue;
                this.preemptionContainerMap.put(containerId, container.getResource());
            }
        }
        this.schedulerMetrics.updateQueueMetrics(pendingResource, allocatedResource, queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SchedulerEvent schedulerEvent) {
        AppAttemptRemovedSchedulerEvent appRemoveEvent;
        SchedulerWrapper wrapper = (SchedulerWrapper)this.scheduler;
        if (!this.metricsON) {
            ((SchedulerWrapper)this.scheduler).propagatedHandle((SchedulerEvent)schedulerEvent);
            return;
        }
        if (!this.schedulerMetrics.isRunning()) {
            this.schedulerMetrics.setRunning(true);
        }
        Timer.Context handlerTimer = null;
        Timer.Context operationTimer = null;
        try {
            if (schedulerEvent.getType() == SchedulerEventType.NODE_UPDATE && schedulerEvent instanceof NodeUpdateSchedulerEvent) {
                NodeUpdateSchedulerEventWrapper eventWrapper = new NodeUpdateSchedulerEventWrapper((NodeUpdateSchedulerEvent)schedulerEvent);
                schedulerEvent = eventWrapper;
                this.updateQueueWithNodeUpdate(eventWrapper);
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                ApplicationAttemptId appAttemptId = appRemoveEvent.getApplicationAttemptID();
                String queue = this.appQueueMap.get(appAttemptId);
                SchedulerAppReport app = this.scheduler.getSchedulerAppInfo(appAttemptId);
                if (!app.getLiveContainers().isEmpty()) {
                    RMContainer rmc = (RMContainer)app.getLiveContainers().iterator().next();
                    this.schedulerMetrics.updateQueueMetricsByRelease(rmc.getContainer().getResource(), queue);
                }
            }
            handlerTimer = this.schedulerMetrics.getSchedulerHandleTimer().time();
            operationTimer = this.schedulerMetrics.getSchedulerHandleTimer((SchedulerEventType)schedulerEvent.getType()).time();
            ((SchedulerWrapper)this.scheduler).propagatedHandle((SchedulerEvent)schedulerEvent);
        }
        finally {
            if (handlerTimer != null) {
                handlerTimer.stop();
            }
            if (operationTimer != null) {
                operationTimer.stop();
            }
            this.schedulerMetrics.increaseSchedulerHandleCounter((SchedulerEventType)schedulerEvent.getType());
            if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                wrapper.getSLSRunner().decreaseRemainingApps();
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                this.appQueueMap.remove(appRemoveEvent.getApplicationAttemptID());
                if (wrapper.getSLSRunner().getRemainingApps() == 0) {
                    try {
                        this.schedulerMetrics.tearDown();
                        SLSRunner.exitSLSRunner();
                    }
                    catch (Exception e) {
                        LOG.error("Scheduler Metrics failed to tear down.", (Throwable)e);
                    }
                }
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_ADDED && schedulerEvent instanceof AppAttemptAddedSchedulerEvent) {
                AppAttemptAddedSchedulerEvent appAddEvent = (AppAttemptAddedSchedulerEvent)schedulerEvent;
                SchedulerApplication app = (SchedulerApplication)this.scheduler.getSchedulerApplications().get(appAddEvent.getApplicationAttemptId().getApplicationId());
                this.appQueueMap.put(appAddEvent.getApplicationAttemptId(), app.getQueue().getQueueName());
            }
        }
    }

    private void updateQueueWithNodeUpdate(NodeUpdateSchedulerEventWrapper eventWrapper) {
        RMNodeWrapper node = (RMNodeWrapper)eventWrapper.getRMNode();
        List<UpdatedContainerInfo> containerList = node.getContainerUpdates();
        for (UpdatedContainerInfo info : containerList) {
            for (ContainerStatus status : info.getCompletedContainers()) {
                ContainerId containerId = status.getContainerId();
                SchedulerAppReport app = this.scheduler.getSchedulerAppInfo(containerId.getApplicationAttemptId());
                if (app == null) continue;
                int releasedMemory = 0;
                int releasedVCores = 0;
                if (status.getExitStatus() == 0) {
                    for (RMContainer rmc : app.getLiveContainers()) {
                        if (rmc.getContainerId() != containerId) continue;
                        Resource resource = rmc.getContainer().getResource();
                        releasedMemory = (int)((long)releasedMemory + resource.getMemorySize());
                        releasedVCores += resource.getVirtualCores();
                        break;
                    }
                } else if (status.getExitStatus() == -100 && this.preemptionContainerMap.containsKey(containerId)) {
                    Resource preResource = this.preemptionContainerMap.get(containerId);
                    releasedMemory = (int)((long)releasedMemory + preResource.getMemorySize());
                    releasedVCores += preResource.getVirtualCores();
                    this.preemptionContainerMap.remove(containerId);
                }
                String queue = this.appQueueMap.get(containerId.getApplicationAttemptId());
                this.schedulerMetrics.updateQueueMetricsByRelease(Resource.newInstance((int)releasedMemory, (int)releasedVCores), queue);
            }
        }
    }

    public SchedulerMetrics getSchedulerMetrics() {
        return this.schedulerMetrics;
    }

    public boolean isMetricsON() {
        return this.metricsON;
    }

    public Tracker getTracker() {
        return this.tracker;
    }
}

