/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.SLSSchedulerCommons;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.Tracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSCapacityScheduler
extends CapacityScheduler
implements SchedulerWrapper,
Configurable {
    private final SLSSchedulerCommons schedulerCommons = new SLSSchedulerCommons((AbstractYarnScheduler<?, ?>)this);
    private Configuration conf;
    private SLSRunner runner;
    private static final Logger LOG = LoggerFactory.getLogger(SLSCapacityScheduler.class);

    public void setConf(Configuration conf) {
        this.conf = conf;
        super.setConf(conf);
        this.schedulerCommons.initMetrics(CapacityScheduler.class, conf);
    }

    public Allocation allocate(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<SchedulingRequest> schedulingRequests, List<ContainerId> containerIds, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        return this.schedulerCommons.allocate(attemptId, resourceRequests, schedulingRequests, containerIds, blacklistAdditions, blacklistRemovals, updateRequests);
    }

    @Override
    public Allocation allocatePropagated(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<SchedulingRequest> schedulingRequests, List<ContainerId> containerIds, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        return super.allocate(attemptId, resourceRequests, schedulingRequests, containerIds, blacklistAdditions, blacklistRemovals, updateRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryCommit(Resource cluster, ResourceCommitRequest r, boolean updatePending) {
        if (this.schedulerCommons.isMetricsON()) {
            boolean isSuccess = false;
            long startTimeNs = System.nanoTime();
            try {
                boolean bl = isSuccess = super.tryCommit(cluster, r, updatePending);
                return bl;
            }
            finally {
                long elapsedNs = System.nanoTime() - startTimeNs;
                if (isSuccess) {
                    this.getSchedulerMetrics().getSchedulerCommitSuccessTimer().update(elapsedNs, TimeUnit.NANOSECONDS);
                    this.getSchedulerMetrics().increaseSchedulerCommitSuccessCounter();
                } else {
                    this.getSchedulerMetrics().getSchedulerCommitFailureTimer().update(elapsedNs, TimeUnit.NANOSECONDS);
                    this.getSchedulerMetrics().increaseSchedulerCommitFailureCounter();
                }
            }
        }
        return super.tryCommit(cluster, r, updatePending);
    }

    public void handle(SchedulerEvent schedulerEvent) {
        try {
            this.schedulerCommons.handle(schedulerEvent);
        }
        catch (Exception e) {
            LOG.error("Caught exception while handling scheduler event", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void propagatedHandle(SchedulerEvent schedulerEvent) {
        super.handle(schedulerEvent);
    }

    public void serviceStop() throws Exception {
        this.schedulerCommons.stopMetrics();
        super.serviceStop();
    }

    @Override
    public String getRealQueueName(String queue) throws YarnException {
        if (this.getQueue(queue) == null) {
            throw new YarnException("Can't find the queue by the given name: " + queue + "! Please check if queue " + queue + " is in the allocation file.");
        }
        return this.getQueue(queue).getQueuePath();
    }

    @Override
    public SchedulerMetrics getSchedulerMetrics() {
        return this.schedulerCommons.getSchedulerMetrics();
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Tracker getTracker() {
        return this.schedulerCommons.getTracker();
    }

    @Override
    public void setSLSRunner(SLSRunner runner) {
        this.runner = runner;
    }

    @Override
    public SLSRunner getSLSRunner() {
        return this.runner;
    }
}

