/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.exceptions.TooManySubscribersException;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.functions.Action0;

public final class TransformerLimitSubscribers<T>
implements Observable.Transformer<T, T> {
    private final AtomicInteger subscriberCount;
    private final int maxSubscribers;

    public TransformerLimitSubscribers(AtomicInteger subscriberCount, int maxSubscribers) {
        this.subscriberCount = subscriberCount;
        this.maxSubscribers = maxSubscribers;
    }

    public Observable<T> call(Observable<T> o) {
        return o.doOnSubscribe(this.onSubscribe()).doOnUnsubscribe(this.onUnsubscribe());
    }

    private Action0 onSubscribe() {
        return new Action0(){

            public void call() {
                if (TransformerLimitSubscribers.this.subscriberCount.incrementAndGet() > TransformerLimitSubscribers.this.maxSubscribers) {
                    throw new TooManySubscribersException();
                }
            }
        };
    }

    private Action0 onUnsubscribe() {
        return new Action0(){

            public void call() {
                TransformerLimitSubscribers.this.subscriberCount.decrementAndGet();
            }
        };
    }
}

