/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.internal.operators.OnSubscribeInputStream;
import com.github.davidmoten.rx.util.ZippedEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import rx.Observable;
import rx.Observer;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.SyncOnSubscribe;

public final class Bytes {
    private Bytes() {
    }

    public static Observable<byte[]> from(InputStream is, int size) {
        return Observable.create((SyncOnSubscribe)new OnSubscribeInputStream(is, size));
    }

    public static Observable<byte[]> from(File file) {
        return Bytes.from(file, 8192);
    }

    public static Observable<byte[]> from(final File file, final int size) {
        Func0<InputStream> resourceFactory = new Func0<InputStream>(){

            public InputStream call() {
                try {
                    return new BufferedInputStream(new FileInputStream(file), size);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Func1<InputStream, Observable<byte[]>> observableFactory = new Func1<InputStream, Observable<byte[]>>(){

            public Observable<byte[]> call(InputStream is) {
                return Bytes.from(is, size);
            }
        };
        return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)InputStreamCloseHolder.INSTANCE, (boolean)true);
    }

    public static Observable<byte[]> from(InputStream is) {
        return Bytes.from(is, 8192);
    }

    public static Observable<ZippedEntry> unzip(final File file) {
        Func0<ZipInputStream> resourceFactory = new Func0<ZipInputStream>(){

            public ZipInputStream call() {
                try {
                    return new ZipInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Func1<ZipInputStream, Observable<ZippedEntry>> observableFactory = ZipHolder.OBSERVABLE_FACTORY;
        Action1<ZipInputStream> disposeAction = ZipHolder.DISPOSER;
        return Observable.using((Func0)resourceFactory, observableFactory, disposeAction);
    }

    public static Observable<ZippedEntry> unzip(InputStream is) {
        return Bytes.unzip(new ZipInputStream(is));
    }

    public static Observable<ZippedEntry> unzip(final ZipInputStream zis) {
        return Observable.create((SyncOnSubscribe)new SyncOnSubscribe<ZipInputStream, ZippedEntry>(){

            protected ZipInputStream generateState() {
                return zis;
            }

            protected ZipInputStream next(ZipInputStream zis2, Observer<? super ZippedEntry> observer) {
                try {
                    ZipEntry zipEntry = zis2.getNextEntry();
                    if (zipEntry != null) {
                        observer.onNext((Object)new ZippedEntry(zipEntry, zis2));
                    } else {
                        zis2.close();
                        observer.onCompleted();
                    }
                }
                catch (IOException e) {
                    observer.onError((Throwable)e);
                }
                return zis2;
            }
        });
    }

    public static Observable.Transformer<byte[], byte[]> collect() {
        return new Observable.Transformer<byte[], byte[]>(){

            public Observable<byte[]> call(Observable<byte[]> source) {
                return source.collect(BosCreatorHolder.INSTANCE, BosCollectorHolder.INSTANCE).map(BosToArrayHolder.INSTANCE);
            }
        };
    }

    private static final class BosToArrayHolder {
        static final Func1<ByteArrayOutputStream, byte[]> INSTANCE = new Func1<ByteArrayOutputStream, byte[]>(){

            public byte[] call(ByteArrayOutputStream bos) {
                return bos.toByteArray();
            }
        };

        private BosToArrayHolder() {
        }
    }

    private static final class BosCollectorHolder {
        static final Action2<ByteArrayOutputStream, byte[]> INSTANCE = new Action2<ByteArrayOutputStream, byte[]>(){

            public void call(ByteArrayOutputStream bos, byte[] bytes) {
                try {
                    bos.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private BosCollectorHolder() {
        }
    }

    private static final class BosCreatorHolder {
        static final Func0<ByteArrayOutputStream> INSTANCE = new Func0<ByteArrayOutputStream>(){

            public ByteArrayOutputStream call() {
                return new ByteArrayOutputStream();
            }
        };

        private BosCreatorHolder() {
        }
    }

    private static final class ZipHolder {
        static final Action1<ZipInputStream> DISPOSER = new Action1<ZipInputStream>(){

            public void call(ZipInputStream zis) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        static final Func1<ZipInputStream, Observable<ZippedEntry>> OBSERVABLE_FACTORY = new Func1<ZipInputStream, Observable<ZippedEntry>>(){

            public Observable<ZippedEntry> call(ZipInputStream zis) {
                return Bytes.unzip(zis);
            }
        };

        private ZipHolder() {
        }
    }

    private static class InputStreamCloseHolder {
        private static final Action1<InputStream> INSTANCE = new Action1<InputStream>(){

            public void call(InputStream is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private InputStreamCloseHolder() {
        }
    }
}

