/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtil {
    private XPath m_xpath;
    private Document m_document;

    public DomUtil(Document document) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.m_xpath = xPathFactory.newXPath();
        this.m_document = document;
    }

    public void populate(final XmlSuite xmlSuite) throws XPathExpressionException {
        NodeList nodeList = this.m_document.getChildNodes();
        final Map<String, String> map = Maps.newHashMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Map<String, NodeProcessor> map2 = Maps.newHashMap();
            map2.put("parameter", new NodeProcessor(){

                @Override
                public void process(Node node) {
                    Element element = (Element)node;
                    map.put(element.getAttribute("name"), element.getAttribute("value"));
                }
            });
            map2.put("test", new NodeProcessor(){

                @Override
                public void process(Node node) {
                    XmlTest xmlTest = new XmlTest(xmlSuite);
                    DomUtil.this.populateTest(xmlTest, node);
                }
            });
            map2.put("suite-files", new NodeProcessor(){

                @Override
                public void process(Node node) {
                    NodeList nodeList = node.getChildNodes();
                    List<String> list = Lists.newArrayList();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node2 = nodeList.item(i);
                        if (!(node2 instanceof Element)) continue;
                        Element element = (Element)node2;
                        if (!"suite-file".equals(node2.getNodeName())) continue;
                        list.add(element.getAttribute("path"));
                    }
                    xmlSuite.setSuiteFiles(list);
                }
            });
            this.parseNodeAndChildren("suite", node, xmlSuite, map2);
        }
        xmlSuite.setParameters(map);
    }

    private void parseNodeAndChildren(String string, Node node, Object object, Map<String, NodeProcessor> map) throws XPathExpressionException {
        if (string.equals(node.getNodeName()) && node.getAttributes() != null) {
            this.populateAttributes(node, object);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string2 = node2.getNodeName();
                NodeProcessor nodeProcessor = map.get(string2);
                if (nodeProcessor != null) {
                    nodeProcessor.process(node2);
                    continue;
                }
                if (string2.startsWith("#")) continue;
                throw new RuntimeException("No processor found for " + string2);
            }
        }
    }

    public static Iterator<Node> findChildren(Node node, String string) {
        List list = Lists.newArrayList();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            list.add(node2);
        }
        return list.iterator();
    }

    private void populateTest(XmlTest xmlTest, Node node) {
        Map<String, String> map = Maps.newHashMap();
        this.populateAttributes(node, xmlTest);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Node node2 = nodeList.item(i);
            if ("parameter".equals(node2.getNodeName())) {
                object2 = (Element)node2;
                map.put(object2.getAttribute("name"), object2.getAttribute("value"));
                continue;
            }
            if ("classes".equals(node2.getNodeName())) {
                object2 = node2.getChildNodes();
                for (int j = 0; j < object2.getLength(); ++j) {
                    object = object2.item(j);
                    if (!"class".equals(object.getNodeName())) continue;
                    XmlClass xmlClass = new XmlClass();
                    this.populateAttributes((Node)object, xmlClass);
                    xmlTest.getClasses().add(xmlClass);
                }
                continue;
            }
            if (!"groups".equals(node2.getNodeName())) continue;
            object2 = node2.getChildNodes();
            List<String> list = Lists.newArrayList();
            object = Lists.newArrayList();
            for (int j = 0; j < object2.getLength(); ++j) {
                Node node3;
                int n;
                NodeList nodeList2;
                Node node4 = object2.item(j);
                if ("run".equals(node4.getNodeName())) {
                    nodeList2 = node4.getChildNodes();
                    for (n = 0; n < nodeList2.getLength(); ++n) {
                        node3 = nodeList2.item(n);
                        if ("include".equals(node3.getNodeName())) {
                            list.add(((Element)node3).getAttribute("name"));
                            continue;
                        }
                        if (!"exclude".equals(node3.getNodeName())) continue;
                        object.add(((Element)node3).getAttribute("name"));
                    }
                    continue;
                }
                if ("dependencies".equals(node4.getNodeName())) {
                    nodeList2 = node4.getChildNodes();
                    for (n = 0; n < nodeList2.getLength(); ++n) {
                        node3 = nodeList2.item(n);
                        if (!"group".equals(node3.getNodeName())) continue;
                        Element element = (Element)node3;
                        xmlTest.addXmlDependencyGroup(element.getAttribute("name"), element.getAttribute("depends-on"));
                    }
                    continue;
                }
                if (!"define".equals(node4.getNodeName())) continue;
                this.xmlDefine(xmlTest, node4);
            }
            xmlTest.setIncludedGroups(list);
            xmlTest.setExcludedGroups((List<String>)object);
        }
        xmlTest.setParameters(map);
    }

    private void xmlDefine(XmlTest xmlTest, Node node) {
        NodeList nodeList = node.getChildNodes();
        List<String> list = Lists.newArrayList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"include".equals(node2.getNodeName())) continue;
            Element element = (Element)node2;
            list.add(element.getAttribute("name"));
        }
        xmlTest.addMetaGroup(((Element)node).getAttribute("name"), list);
    }

    private void populateAttributes(Node node, Object object) {
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node node2 = node.getAttributes().item(i);
            this.p(node.getAttributes().item(i).toString());
            this.setProperty(object, node2.getLocalName(), node2.getNodeValue());
        }
    }

    private void setProperty(Object object, String string, Object object2) {
        String string2 = this.toCamelCaseSetter(string);
        Method method = null;
        for (Method method2 : object.getClass().getDeclaredMethods()) {
            if (!method2.getName().equals(string2)) continue;
            method = method2;
            break;
        }
        if (method == null) {
            this.p("Warning: couldn't find setter method " + string2);
        } else {
            try {
                this.p("Invoking " + string2 + " with " + object2);
                Class<?> exception = method.getParameterTypes()[0];
                if (exception == Boolean.class || exception == Boolean.TYPE) {
                    method.invoke(object, Boolean.parseBoolean(object2.toString()));
                } else if (exception == Integer.class || exception == Integer.TYPE) {
                    method.invoke(object, Integer.parseInt(object2.toString()));
                } else {
                    method.invoke(object, object2.toString());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void p(String string) {
    }

    private String toCamelCaseSetter(String string) {
        StringBuilder stringBuilder = new StringBuilder("set" + string.substring(0, 1).toUpperCase());
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == '-') {
                stringBuilder.append(Character.toUpperCase(string.charAt(i + 1)));
                ++i;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static interface NodeProcessor {
        public void process(Node var1);
    }
}

