/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

public enum StorageFormat {
    SEQUENCEFILE("org.apache.hadoop.mapred.SequenceFileInputFormat", "org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"),
    TEXTFILE("org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"),
    RCFILE("org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", "org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe"),
    ORC("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcSerde"),
    PARQUET("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe"),
    AVRO("org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat", "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat", "org.apache.hadoop.hive.serde2.avro.AvroSerDe"),
    JSON("org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "org.apache.hive.hcatalog.data.JsonSerDe"),
    CSV("org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "org.apache.hadoop.hive.serde2.OpenCSVSerde"),
    REGEX("org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "org.apache.hadoop.hive.serde2.RegexSerDe");

    private final String inputFormat;
    private final String outputFormat;
    private final String serde;

    private StorageFormat(String inputFormat, String outputFormat, String serde) {
        if (inputFormat == null) {
            throw new RuntimeException("inputFormat must not be null");
        }
        if (outputFormat == null) {
            throw new RuntimeException("outputFormat must not be null");
        }
        if (serde == null) {
            throw new RuntimeException("serde must not be null");
        }
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serde = serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getSerde() {
        return this.serde;
    }
}

