/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.UUID;
import org.apache.iceberg.expressions.Literals;
import org.apache.iceberg.types.Type;

public interface Literal<T>
extends Serializable {
    public static Literal<Boolean> of(boolean value) {
        return new Literals.BooleanLiteral(value);
    }

    public static Literal<Integer> of(int value) {
        return new Literals.IntegerLiteral(value);
    }

    public static Literal<Long> of(long value) {
        return new Literals.LongLiteral(value);
    }

    public static Literal<Float> of(float value) {
        return new Literals.FloatLiteral(Float.valueOf(value));
    }

    public static Literal<Double> of(double value) {
        return new Literals.DoubleLiteral(value);
    }

    public static Literal<CharSequence> of(CharSequence value) {
        return new Literals.StringLiteral(value);
    }

    public static Literal<UUID> of(UUID value) {
        return new Literals.UUIDLiteral(value);
    }

    public static Literal<ByteBuffer> of(byte[] value) {
        return new Literals.FixedLiteral(ByteBuffer.wrap(value));
    }

    public static Literal<ByteBuffer> of(ByteBuffer value) {
        return new Literals.BinaryLiteral(value);
    }

    public static Literal<BigDecimal> of(BigDecimal value) {
        return new Literals.DecimalLiteral(value);
    }

    public T value();

    public <X> Literal<X> to(Type var1);

    public Comparator<T> comparator();

    default public ByteBuffer toByteBuffer() {
        throw new UnsupportedOperationException("toByteBuffer is not supported");
    }
}

