/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TopicPO {
    private Long topicId;
    private String topicName;
    private Long metalakeId;
    private Long catalogId;
    private Long schemaId;
    private String comment;
    private String properties;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicPO)) {
            return false;
        }
        TopicPO topicPO = (TopicPO)o;
        return Objects.equal((Object)this.topicId, (Object)topicPO.topicId) && Objects.equal((Object)this.topicName, (Object)topicPO.topicName) && Objects.equal((Object)this.metalakeId, (Object)topicPO.metalakeId) && Objects.equal((Object)this.catalogId, (Object)topicPO.catalogId) && Objects.equal((Object)this.schemaId, (Object)topicPO.schemaId) && Objects.equal((Object)this.comment, (Object)topicPO.comment) && Objects.equal((Object)this.properties, (Object)topicPO.properties) && Objects.equal((Object)this.auditInfo, (Object)topicPO.auditInfo) && Objects.equal((Object)this.currentVersion, (Object)topicPO.currentVersion) && Objects.equal((Object)this.lastVersion, (Object)topicPO.lastVersion) && Objects.equal((Object)this.deletedAt, (Object)topicPO.deletedAt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topicId, this.topicName, this.metalakeId, this.catalogId, this.schemaId, this.comment, this.properties, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt});
    }

    public Long getTopicId() {
        return this.topicId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final TopicPO topicPO = new TopicPO();

        private Builder() {
        }

        public Builder withTopicId(Long topicId) {
            this.topicPO.topicId = topicId;
            return this;
        }

        public Builder withTopicName(String topicName) {
            this.topicPO.topicName = topicName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.topicPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.topicPO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaId(Long schemaId) {
            this.topicPO.schemaId = schemaId;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.topicPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.topicPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.topicPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.topicPO.deletedAt = deletedAt;
            return this;
        }

        public Builder withComment(String comment) {
            this.topicPO.comment = comment;
            return this;
        }

        public Builder withProperties(String properties) {
            this.topicPO.properties = properties;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.topicPO.topicId != null ? 1 : 0) != 0, (Object)"topicId cannot be null");
            Preconditions.checkArgument((this.topicPO.topicName != null ? 1 : 0) != 0, (Object)"topicName cannot be null");
            Preconditions.checkArgument((this.topicPO.metalakeId != null ? 1 : 0) != 0, (Object)"metalakeId cannot be null");
            Preconditions.checkArgument((this.topicPO.catalogId != null ? 1 : 0) != 0, (Object)"catalogId cannot be null");
            Preconditions.checkArgument((this.topicPO.schemaId != null ? 1 : 0) != 0, (Object)"schemaId cannot be null");
            Preconditions.checkArgument((this.topicPO.auditInfo != null ? 1 : 0) != 0, (Object)"auditInfo cannot be null");
            Preconditions.checkArgument((this.topicPO.currentVersion != null ? 1 : 0) != 0, (Object)"currentVersion cannot be null");
            Preconditions.checkArgument((this.topicPO.lastVersion != null ? 1 : 0) != 0, (Object)"lastVersion cannot be null");
            Preconditions.checkArgument((this.topicPO.deletedAt != null ? 1 : 0) != 0, (Object)"deletedAt cannot be null");
        }

        public TopicPO build() {
            this.validate();
            return this.topicPO;
        }
    }
}

