/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.Console;
import java.io.Reader;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Future;
import org.springframework.util.ClassUtils;

public enum JavaVersion {
    SEVENTEEN("17", Console.class, "charset", new Class[0]),
    EIGHTEEN("18", Duration.class, "isPositive", new Class[0]),
    NINETEEN("19", Future.class, "state", new Class[0]),
    TWENTY("20", Class.class, "accessFlags", new Class[0]),
    TWENTY_ONE("21", SortedSet.class, "getFirst", new Class[0]),
    TWENTY_TWO("22", Console.class, "isTerminal", new Class[0]),
    TWENTY_THREE("23", NumberFormat.class, "isStrict", new Class[0]),
    TWENTY_FOUR("24", Reader.class, "of", CharSequence.class);

    private final String name;
    private final boolean available;

    private JavaVersion(String name, Class<?> versionSpecificClass, String versionSpecificMethod, Class<?> ... paramTypes) {
        this.name = name;
        this.available = ClassUtils.hasMethod(versionSpecificClass, versionSpecificMethod, paramTypes);
    }

    public String toString() {
        return this.name;
    }

    public static JavaVersion getJavaVersion() {
        List<JavaVersion> candidates = Arrays.asList(JavaVersion.values());
        Collections.reverse(candidates);
        for (JavaVersion candidate : candidates) {
            if (!candidate.available) continue;
            return candidate;
        }
        return SEVENTEEN;
    }

    public boolean isEqualOrNewerThan(JavaVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isOlderThan(JavaVersion version) {
        return this.compareTo(version) < 0;
    }
}

