/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.database.GormOneOfFeature;
import org.grails.forge.feature.database.TestContainers;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.Options;

@Singleton
public class MongoGorm
extends GormOneOfFeature {
    private final TestContainers testContainers;

    public MongoGorm(TestContainers testContainers) {
        this.testContainers = testContainers;
    }

    @Override
    public String getName() {
        return "gorm-mongodb";
    }

    @Override
    public String getTitle() {
        return "GORM for MongoDB";
    }

    @Override
    public String getDescription() {
        return "Configure GORM for using MongoDB.";
    }

    @Override
    public void processSelectedFeatures(FeatureContext featureContext) {
        super.processSelectedFeatures(featureContext);
        if (!featureContext.isPresent(TestContainers.class) && this.testContainers != null) {
            featureContext.addFeature(this.testContainers);
        }
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        this.applyDefaultGormConfig(generatorContext.getConfiguration());
        ApplicationConfiguration config = generatorContext.getConfiguration();
        config.put("grails.mongodb.url", "mongodb://${MONGO_HOST:localhost}:${MONGO_PORT:27017}/foo");
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-data-mongodb").implementation());
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return selectedFeatures.stream().anyMatch(f -> f instanceof MongoGorm) || options.getGormImpl() == GormImpl.MONGODB;
    }

    @Override
    @Nullable
    public String getThirdPartyDocumentation() {
        return "https://docs.grails.org/latest/grails-data/mongodb/manual/";
    }
}

