/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.ArgumentMappingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.CommonTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ExplicitTypeStrategy;
import org.apache.flink.table.types.inference.strategies.FirstTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ForceNullableTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MappingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MatchFamilyTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MissingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.NullableIfArgsTypeStrategy;
import org.apache.flink.table.types.inference.strategies.VaryingStringTypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class TypeStrategies {
    public static final TypeStrategy MISSING = new MissingTypeStrategy();
    public static final TypeStrategy COMMON = new CommonTypeStrategy();

    public static TypeStrategy commonRange(ArgumentCount argumentRange) {
        return new CommonTypeStrategy(argumentRange);
    }

    public static TypeStrategy explicit(DataType dataType) {
        return new ExplicitTypeStrategy(dataType);
    }

    public static TypeStrategy argument(int pos) {
        return new ArgumentMappingTypeStrategy(pos, Optional::of);
    }

    public static TypeStrategy argument(int pos, Function<DataType, Optional<DataType>> mapper) {
        return new ArgumentMappingTypeStrategy(pos, mapper);
    }

    public static TypeStrategy first(TypeStrategy ... strategies) {
        return new FirstTypeStrategy(Arrays.asList(strategies));
    }

    public static TypeStrategy matchFamily(int argumentPos, LogicalTypeFamily family) {
        return new MatchFamilyTypeStrategy(argumentPos, family);
    }

    public static TypeStrategy mapping(Map<InputTypeStrategy, TypeStrategy> mappings) {
        return new MappingTypeStrategy(mappings);
    }

    public static TypeStrategy forceNullable(TypeStrategy initialStrategy) {
        return new ForceNullableTypeStrategy(initialStrategy);
    }

    public static TypeStrategy nullableIfArgs(ConstantArgumentCount includedArgs, TypeStrategy initialStrategy) {
        return new NullableIfArgsTypeStrategy(includedArgs, initialStrategy, false);
    }

    public static TypeStrategy nullableIfArgs(TypeStrategy initialStrategy) {
        return TypeStrategies.nullableIfArgs(ConstantArgumentCount.any(), initialStrategy);
    }

    public static TypeStrategy nullableIfAllArgs(ConstantArgumentCount includedArgs, TypeStrategy initialStrategy) {
        return new NullableIfArgsTypeStrategy(includedArgs, initialStrategy, true);
    }

    public static TypeStrategy nullableIfAllArgs(TypeStrategy initialStrategy) {
        return TypeStrategies.nullableIfAllArgs(ConstantArgumentCount.any(), initialStrategy);
    }

    public static TypeStrategy varyingString(TypeStrategy initialStrategy) {
        return new VaryingStringTypeStrategy(initialStrategy);
    }

    public static TypeStrategy aggArg0(Function<LogicalType, LogicalType> aggType, boolean nullableIfGroupingEmpty) {
        return callContext -> {
            DataType argDataType = callContext.getArgumentDataTypes().get(0);
            LogicalType argType = argDataType.getLogicalType();
            LogicalType result = (LogicalType)aggType.apply(argType);
            if (nullableIfGroupingEmpty && !callContext.isGroupedAggregation()) {
                result = result.copy(true);
            } else if (!nullableIfGroupingEmpty) {
                result = result.copy(false);
            }
            return Optional.of(TypeConversions.fromLogicalToDataType(result));
        };
    }

    private TypeStrategies() {
    }
}

