/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayDistinctFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final SpecializedFunction.ExpressionEvaluator equalityEvaluator;
    private transient MethodHandle equalityHandle;

    public ArrayDistinctFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_DISTINCT, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
        this.equalityEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element1").isEqual((Object)Expressions.$((String)"element2")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)dataType.notNull()).toInternal()), DataTypes.FIELD((String)"element2", (DataType)((DataType)dataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.equalityHandle = this.equalityEvaluator.open(context);
    }

    @Nullable
    public ArrayData eval(ArrayData haystack) {
        try {
            if (haystack == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            boolean alreadyStoredNull = false;
            for (int i = 0; i < haystack.size(); ++i) {
                Object element1 = this.elementGetter.getElementOrNull(haystack, i);
                if (element1 != null) {
                    boolean found = false;
                    for (int j = 0; !found && j < list.size(); ++j) {
                        Object element2 = list.get(j);
                        if (element2 == null) continue;
                        found = this.equalityHandle.invoke(element1, element2);
                    }
                    if (found) continue;
                    list.add(element1);
                    continue;
                }
                if (alreadyStoredNull) continue;
                list.add(element1);
                alreadyStoredNull = true;
            }
            return new GenericArrayData(list.toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    public void close() throws Exception {
        this.equalityEvaluator.close();
    }
}

