/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.utils.EncodingUtils;

@Deprecated
@PublicEvolving
public class TypeStringUtils {
    private static final String VARCHAR = "VARCHAR";
    private static final String STRING = "STRING";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String BYTE = "BYTE";
    private static final String TINYINT = "TINYINT";
    private static final String SHORT = "SHORT";
    private static final String SMALLINT = "SMALLINT";
    private static final String INT = "INT";
    private static final String LONG = "LONG";
    private static final String BIGINT = "BIGINT";
    private static final String FLOAT = "FLOAT";
    private static final String DOUBLE = "DOUBLE";
    private static final String DECIMAL = "DECIMAL";
    private static final String SQL_DATE = "SQL_DATE";
    private static final String DATE = "DATE";
    private static final String SQL_TIME = "SQL_TIME";
    private static final String TIME = "TIME";
    private static final String SQL_TIMESTAMP = "SQL_TIMESTAMP";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String ROW = "ROW";
    private static final String ANY = "ANY";
    private static final String POJO = "POJO";
    private static final String MAP = "MAP";
    private static final String MULTISET = "MULTISET";
    private static final String PRIMITIVE_ARRAY = "PRIMITIVE_ARRAY";
    private static final String OBJECT_ARRAY = "OBJECT_ARRAY";

    public static String writeTypeInfo(TypeInformation<?> typeInfo) {
        if (typeInfo.equals((Object)Types.STRING)) {
            return VARCHAR;
        }
        if (typeInfo.equals((Object)Types.BOOLEAN)) {
            return BOOLEAN;
        }
        if (typeInfo.equals((Object)Types.BYTE)) {
            return TINYINT;
        }
        if (typeInfo.equals((Object)Types.SHORT)) {
            return SMALLINT;
        }
        if (typeInfo.equals((Object)Types.INT)) {
            return INT;
        }
        if (typeInfo.equals((Object)Types.LONG)) {
            return BIGINT;
        }
        if (typeInfo.equals((Object)Types.FLOAT)) {
            return FLOAT;
        }
        if (typeInfo.equals((Object)Types.DOUBLE)) {
            return DOUBLE;
        }
        if (typeInfo.equals((Object)Types.BIG_DEC)) {
            return DECIMAL;
        }
        if (typeInfo.equals((Object)Types.SQL_DATE) || typeInfo.equals((Object)Types.LOCAL_DATE)) {
            return DATE;
        }
        if (typeInfo.equals((Object)Types.SQL_TIME) || typeInfo.equals((Object)Types.LOCAL_TIME)) {
            return TIME;
        }
        if (typeInfo.equals((Object)Types.SQL_TIMESTAMP) || typeInfo.equals((Object)Types.LOCAL_DATE_TIME)) {
            return TIMESTAMP;
        }
        if (typeInfo instanceof RowTypeInfo) {
            RowTypeInfo rt = (RowTypeInfo)typeInfo;
            String[] fieldNames = rt.getFieldNames();
            TypeInformation[] fieldTypes = rt.getFieldTypes();
            StringBuilder result = new StringBuilder();
            result.append(ROW);
            result.append('<');
            for (int i = 0; i < fieldNames.length; ++i) {
                if (TypeStringUtils.containsDelimiter(fieldNames[i])) {
                    result.append('`');
                    result.append(fieldNames[i].replace("`", "``"));
                    result.append('`');
                } else {
                    result.append(fieldNames[i]);
                }
                result.append(' ');
                result.append(TypeStringUtils.writeTypeInfo(fieldTypes[i]));
                if (i >= fieldNames.length - 1) continue;
                result.append(", ");
            }
            result.append('>');
            return result.toString();
        }
        if (typeInfo instanceof GenericTypeInfo) {
            return "ANY<" + typeInfo.getTypeClass().getName() + '>';
        }
        if (typeInfo instanceof PojoTypeInfo) {
            TypeInformation extractedPojo;
            try {
                extractedPojo = TypeExtractor.createTypeInfo((Class)typeInfo.getTypeClass());
            }
            catch (InvalidTypesException e) {
                extractedPojo = null;
            }
            if (extractedPojo == null || !typeInfo.equals((Object)extractedPojo)) {
                throw new TableException("A string representation for custom POJO types is not supported yet.");
            }
            return "POJO<" + typeInfo.getTypeClass().getName() + '>';
        }
        if (typeInfo instanceof PrimitiveArrayTypeInfo) {
            PrimitiveArrayTypeInfo arrayTypeInfo = (PrimitiveArrayTypeInfo)typeInfo;
            return "PRIMITIVE_ARRAY<" + TypeStringUtils.writeTypeInfo(arrayTypeInfo.getComponentType()) + '>';
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo arrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            return "OBJECT_ARRAY<" + TypeStringUtils.writeTypeInfo(arrayTypeInfo.getComponentInfo()) + '>';
        }
        if (typeInfo instanceof MultisetTypeInfo) {
            MultisetTypeInfo multisetTypeInfo = (MultisetTypeInfo)typeInfo;
            return "MULTISET<" + TypeStringUtils.writeTypeInfo(multisetTypeInfo.getElementTypeInfo()) + '>';
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            String keyTypeInfo = TypeStringUtils.writeTypeInfo(mapTypeInfo.getKeyTypeInfo());
            String valueTypeInfo = TypeStringUtils.writeTypeInfo(mapTypeInfo.getValueTypeInfo());
            return "MAP<" + keyTypeInfo + ", " + valueTypeInfo + '>';
        }
        return "ANY<" + typeInfo.getTypeClass().getName() + ", " + EncodingUtils.encodeObjectToString(typeInfo) + '>';
    }

    public static TypeInformation<?> readTypeInfo(String typeString) {
        List<Token> tokens = TypeStringUtils.tokenize(typeString);
        TokenConverter converter = new TokenConverter(typeString, tokens);
        return converter.convert();
    }

    private static boolean containsDelimiter(String string) {
        char[] charArray;
        for (char c : charArray = string.toCharArray()) {
            if (!TypeStringUtils.isDelimiter(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDelimiter(char character) {
        return Character.isWhitespace(character) || character == ',' || character == '<' || character == '>' || character == '(' || character == ')';
    }

    private static List<Token> tokenize(String typeString) {
        char[] chars = typeString.toCharArray();
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int cursor = 0; cursor < chars.length; ++cursor) {
            char curChar = chars[cursor];
            if (curChar == '<' || curChar == '(') {
                tokens.add(new Token(TokenType.BEGIN, Character.toString(curChar), cursor));
                continue;
            }
            if (curChar == '>' || curChar == ')') {
                tokens.add(new Token(TokenType.END, Character.toString(curChar), cursor));
                continue;
            }
            if (curChar == ',') {
                tokens.add(new Token(TokenType.SEPARATOR, Character.toString(curChar), cursor));
                continue;
            }
            if (Character.isWhitespace(curChar)) continue;
            StringBuilder literal = new StringBuilder();
            boolean isEscaped = false;
            while (cursor < chars.length && (!TypeStringUtils.isDelimiter(chars[cursor]) || isEscaped)) {
                curChar = chars[cursor++];
                if (!isEscaped && curChar == '`') {
                    isEscaped = true;
                    continue;
                }
                if (isEscaped && curChar == '`' && cursor < chars.length && chars[cursor] == '`') {
                    ++cursor;
                    literal.append(curChar);
                    continue;
                }
                if (isEscaped && curChar == '`') break;
                literal.append(curChar);
            }
            tokens.add(new Token(TokenType.LITERAL, literal.toString(), --cursor));
        }
        return tokens;
    }

    private static class TokenConverter {
        private String inputString;
        private List<Token> tokens;
        private int lastValidToken;
        private int currentToken;

        public TokenConverter(String inputString, List<Token> tokens) {
            this.inputString = inputString;
            this.tokens = tokens;
            this.lastValidToken = -1;
            this.currentToken = -1;
        }

        public TypeInformation<?> convert() {
            this.nextToken(TokenType.LITERAL);
            TypeInformation<?> typeInfo = this.convertType();
            if (this.hasRemainingTokens()) {
                this.nextToken();
                throw this.parsingError("Unexpected token: " + this.token().literal);
            }
            return typeInfo;
        }

        private TypeInformation<?> convertType() {
            switch (this.token().literal) {
                case "VARCHAR": 
                case "STRING": {
                    return Types.STRING;
                }
                case "BOOLEAN": {
                    return Types.BOOLEAN;
                }
                case "TINYINT": 
                case "BYTE": {
                    return Types.BYTE;
                }
                case "SMALLINT": 
                case "SHORT": {
                    return Types.SHORT;
                }
                case "INT": {
                    return Types.INT;
                }
                case "BIGINT": 
                case "LONG": {
                    return Types.LONG;
                }
                case "FLOAT": {
                    return Types.FLOAT;
                }
                case "DOUBLE": {
                    return Types.DOUBLE;
                }
                case "DECIMAL": {
                    return Types.BIG_DEC;
                }
                case "DATE": 
                case "SQL_DATE": {
                    return Types.SQL_DATE;
                }
                case "TIMESTAMP": 
                case "SQL_TIMESTAMP": {
                    return Types.SQL_TIMESTAMP;
                }
                case "TIME": 
                case "SQL_TIME": {
                    return Types.SQL_TIME;
                }
                case "ROW": {
                    return this.convertRow();
                }
                case "ANY": {
                    return this.convertAny();
                }
                case "POJO": {
                    return this.convertPojo();
                }
                case "MAP": {
                    return this.convertMap();
                }
                case "MULTISET": {
                    return this.convertMultiset();
                }
                case "PRIMITIVE_ARRAY": {
                    return this.convertPrimitiveArray();
                }
                case "OBJECT_ARRAY": {
                    return this.convertObjectArray();
                }
            }
            throw this.parsingError("Unsupported type: " + this.token().literal);
        }

        private TypeInformation<?> convertRow() {
            this.nextToken(TokenType.BEGIN);
            if (this.isNextToken(2, TokenType.LITERAL)) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList types = new ArrayList();
                while (this.hasRemainingTokens()) {
                    this.nextToken(TokenType.LITERAL);
                    names.add(this.token().literal);
                    this.nextToken(TokenType.LITERAL);
                    types.add(this.convertType());
                    if (this.isNextToken(1, TokenType.END)) break;
                    this.nextToken(TokenType.SEPARATOR);
                }
                this.nextToken(TokenType.END);
                return Types.ROW_NAMED((String[])names.toArray(new String[0]), (TypeInformation[])types.toArray(new TypeInformation[0]));
            }
            ArrayList types = new ArrayList();
            while (this.hasRemainingTokens()) {
                this.nextToken(TokenType.LITERAL);
                types.add(this.convertType());
                if (this.isNextToken(1, TokenType.END)) break;
                this.nextToken(TokenType.SEPARATOR);
            }
            this.nextToken(TokenType.END);
            return Types.ROW((TypeInformation[])types.toArray(new TypeInformation[0]));
        }

        private TypeInformation<?> convertAny() {
            this.nextToken(TokenType.BEGIN);
            if (this.isNextToken(2, TokenType.SEPARATOR)) {
                this.nextToken(TokenType.LITERAL);
                String className = this.token().literal;
                this.nextToken(TokenType.SEPARATOR);
                this.nextToken(TokenType.LITERAL);
                String serialized = this.token().literal;
                this.nextToken(TokenType.END);
                Class<?> clazz = EncodingUtils.loadClass(className);
                TypeInformation typeInfo = EncodingUtils.decodeStringToObject(serialized, TypeInformation.class);
                if (!clazz.equals(typeInfo.getTypeClass())) {
                    throw new ValidationException("Class '" + clazz + "' does no correspond to serialized data.");
                }
                return typeInfo;
            }
            this.nextToken(TokenType.LITERAL);
            String className = this.token().literal;
            this.nextToken(TokenType.END);
            Class<?> clazz = EncodingUtils.loadClass(className);
            return Types.GENERIC(clazz);
        }

        private TypeInformation<?> convertPojo() {
            this.nextToken(TokenType.BEGIN);
            this.nextToken(TokenType.LITERAL);
            String className = this.token().literal;
            this.nextToken(TokenType.END);
            Class<?> clazz = EncodingUtils.loadClass(className);
            return Types.POJO(clazz);
        }

        private TypeInformation<?> convertMap() {
            this.nextToken(TokenType.BEGIN);
            this.nextToken(TokenType.LITERAL);
            TypeInformation<?> keyTypeInfo = this.convertType();
            this.nextToken(TokenType.SEPARATOR);
            this.nextToken(TokenType.LITERAL);
            TypeInformation<?> valueTypeInfo = this.convertType();
            this.nextToken(TokenType.END);
            return Types.MAP(keyTypeInfo, valueTypeInfo);
        }

        private TypeInformation<?> convertMultiset() {
            this.nextToken(TokenType.BEGIN);
            this.nextToken(TokenType.LITERAL);
            TypeInformation<?> elementTypeInfo = this.convertType();
            this.nextToken(TokenType.END);
            return new MultisetTypeInfo(elementTypeInfo);
        }

        private TypeInformation<?> convertPrimitiveArray() {
            this.nextToken(TokenType.BEGIN);
            this.nextToken(TokenType.LITERAL);
            TypeInformation<?> elementTypeInfo = this.convertType();
            this.nextToken(TokenType.END);
            return Types.PRIMITIVE_ARRAY(elementTypeInfo);
        }

        private TypeInformation<?> convertObjectArray() {
            this.nextToken(TokenType.BEGIN);
            this.nextToken(TokenType.LITERAL);
            TypeInformation<?> elementTypeInfo = this.convertType();
            this.nextToken(TokenType.END);
            return Types.OBJECT_ARRAY(elementTypeInfo);
        }

        private void nextToken(TokenType type) {
            this.nextToken();
            Token nextToken = this.tokens.get(this.currentToken);
            if (nextToken.type != type) {
                throw this.parsingError(type.name() + " expected but was " + (Object)((Object)nextToken.type) + '.');
            }
        }

        private void nextToken() {
            ++this.currentToken;
            if (this.currentToken >= this.tokens.size()) {
                throw this.parsingError("Unexpected end.");
            }
            this.lastValidToken = this.currentToken - 1;
        }

        private boolean isNextToken(int lookAhead, TokenType type) {
            return this.currentToken + lookAhead < this.tokens.size() && this.tokens.get((int)(this.currentToken + lookAhead)).type == type;
        }

        private int lastCursor() {
            if (this.lastValidToken < 0) {
                return 0;
            }
            return this.tokens.get((int)this.lastValidToken).cursorPosition + 1;
        }

        private ValidationException parsingError(String cause) {
            throw new ValidationException("Could not parse type information at position " + this.lastCursor() + ": " + cause + "\nInput type string: " + this.inputString);
        }

        private Token token() {
            return this.tokens.get(this.currentToken);
        }

        private boolean hasRemainingTokens() {
            return this.currentToken + 1 < this.tokens.size();
        }
    }

    private static class Token {
        public final TokenType type;
        public final String literal;
        public final int cursorPosition;

        public Token(TokenType type, String literal, int cursorPosition) {
            this.type = type;
            this.literal = literal;
            this.cursorPosition = cursorPosition;
        }
    }

    private static enum TokenType {
        LITERAL,
        BEGIN,
        END,
        SEPARATOR;

    }
}

