/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Frame;
import flash.swf.Header;
import flash.swf.Movie;
import flash.swf.Tag;
import flash.swf.TagHandler;
import flash.swf.tags.DebugID;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.DoAction;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.ImportAssets;
import flash.swf.tags.ShowFrame;
import flash.swf.tags.SymbolClass;
import flash.swf.types.ActionList;
import flash.swf.types.ImportRecord;
import java.util.HashSet;
import java.util.Iterator;

public class MovieEncoder {
    private final TagHandler handler;
    private HashSet<Tag> done;
    private boolean compress;

    public MovieEncoder(TagHandler handler) {
        this.handler = handler;
        this.done = new HashSet();
    }

    public void export(Movie m) {
        this.export(m, Header.useCompression(m.version));
    }

    public void export(Movie m, boolean compress) {
        Header h = new Header();
        h.version = m.version;
        h.compressed = compress;
        h.size = m.size;
        h.rate = m.framerate;
        this.handler.header(h);
        if (m.fileAttributes != null) {
            if (m.metadata != null) {
                m.fileAttributes.hasMetadata = true;
            }
            m.fileAttributes.visit(this.handler);
        }
        if (m.enableTelemetry != null) {
            m.enableTelemetry.visit(this.handler);
        }
        if (m.metadata != null) {
            m.metadata.visit(this.handler);
        }
        if (m.enableDebugger != null) {
            m.enableDebugger.visit(this.handler);
        }
        if (m.uuid != null) {
            new DebugID(m.uuid).visit(this.handler);
        }
        if (m.protect != null) {
            m.protect.visit(this.handler);
        }
        if (m.scriptLimits != null) {
            m.scriptLimits.visit(this.handler);
        }
        if (m.bgcolor != null) {
            m.bgcolor.visit(this.handler);
        }
        if (m.productInfo != null) {
            m.productInfo.visit(this.handler);
        }
        if (m.sceneAndFrameLabelData != null) {
            m.sceneAndFrameLabelData.visit(this.handler);
        }
        boolean associateRootClass = m.topLevelClass != null;
        for (Frame frame : m.frames) {
            if (frame.label != null) {
                frame.label.visit(this.handler);
            }
            if (!frame.imports.isEmpty()) {
                for (ImportAssets importAssets : frame.imports) {
                    importAssets.visit(this.handler);
                }
            }
            Iterator<Tag> j = frame.getReferences();
            while (j.hasNext()) {
                DefineTag defineTag = (DefineTag)j.next();
                this.define(defineTag);
            }
            if (frame.hasExports()) {
                ExportAssets exportAssets = new ExportAssets();
                Iterator<DefineTag> iterator = frame.exportIterator();
                while (iterator.hasNext()) {
                    Tag tag = iterator.next();
                    exportAssets.exports.add(tag);
                }
                exportAssets.visit(this.handler);
            }
            if (frame.hasFonts()) {
                Iterator<DefineFont> k = frame.fontsIterator();
                while (k.hasNext()) {
                    DefineFont defineFont = k.next();
                    if (this.done.contains(defineFont)) continue;
                    defineFont.visit(this.handler);
                    this.done.add(defineFont);
                }
            }
            for (Tag tag : frame.doABCs) {
                tag.visit(this.handler);
            }
            SymbolClass classes = new SymbolClass();
            if (frame.hasSymbolClasses()) {
                classes.class2tag.putAll(frame.symbolClass.class2tag);
            }
            if (associateRootClass) {
                classes.topLevelClass = m.topLevelClass;
            }
            if (associateRootClass || frame.hasSymbolClasses()) {
                classes.visit(this.handler);
            }
            associateRootClass = false;
            for (Tag tag : frame.controlTags) {
                tag.visit(this.handler);
            }
            for (ActionList list : frame.doActions) {
                new DoAction(list).visit(this.handler);
            }
            new ShowFrame().visit(this.handler);
        }
        this.handler.finish();
    }

    public void define(Tag tag) {
        if (!this.done.contains(tag)) {
            Iterator<Tag> i = tag.getReferences();
            while (i.hasNext()) {
                Tag ref = i.next();
                this.define(ref);
            }
            if (!(tag instanceof ImportRecord)) {
                tag.visit(this.handler);
                Tag visitAfter = null;
                if (tag instanceof DefineSprite) {
                    visitAfter = ((DefineSprite)tag).scalingGrid;
                } else if (tag instanceof DefineButton) {
                    visitAfter = ((DefineButton)tag).scalingGrid;
                } else if (tag instanceof DefineShape) {
                    visitAfter = ((DefineShape)tag).scalingGrid;
                } else if (tag instanceof DefineFont3) {
                    visitAfter = ((DefineFont3)tag).zones;
                } else if (tag instanceof DefineEditText) {
                    visitAfter = ((DefineEditText)tag).csmTextSettings;
                } else if (tag instanceof DefineText) {
                    visitAfter = ((DefineText)tag).csmTextSettings;
                }
                this.visitAfter(visitAfter);
                visitAfter = null;
                if (tag instanceof DefineFont) {
                    visitAfter = ((DefineFont)tag).license;
                }
                this.visitAfter(visitAfter);
            }
            this.done.add(tag);
        }
    }

    private void visitAfter(Tag visitAfter) {
        if (visitAfter != null) {
            assert (!this.done.contains(visitAfter));
            visitAfter.visit(this.handler);
            this.done.add(visitAfter);
        }
    }
}

