/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.extensions;

import flex2.compiler.extensions.IApplicationExtension;
import flex2.compiler.extensions.ICompcExtension;
import flex2.compiler.extensions.IConfigurableExtension;
import flex2.compiler.extensions.ILibraryExtension;
import flex2.compiler.extensions.IMxmlcExtension;
import flex2.compiler.extensions.IPreCompileExtension;
import flex2.compiler.extensions.IPreLinkExtension;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManager {
    public static Set<IPreLinkExtension> getPreLinkExtensions(Map<String, List<String>> extensions) {
        return ExtensionManager.getExtension(ExtensionType.PRELINK, extensions, IPreLinkExtension.class);
    }

    public static Set<IMxmlcExtension> getMxmlcExtensions(Map<String, List<String>> extensions) {
        return ExtensionManager.getExtension(ExtensionType.MXMLC, extensions, IMxmlcExtension.class);
    }

    public static Set<ICompcExtension> getCompcExtensions(Map<String, List<String>> extensions) {
        return ExtensionManager.getExtension(ExtensionType.COMPC, extensions, ICompcExtension.class);
    }

    public static Set<ILibraryExtension> getLibraryExtensions(Map<String, List<String>> extensions) {
        return ExtensionManager.getExtension(ExtensionType.LIBRARY, extensions, ILibraryExtension.class);
    }

    public static Set<IApplicationExtension> getApplicationExtensions(Map<String, List<String>> extensions) {
        return ExtensionManager.getExtension(ExtensionType.APPLICATION, extensions, IApplicationExtension.class);
    }

    public static Set<IPreCompileExtension> getPreCompileExtensions(Map<String, List<String>> extensions) {
        return ExtensionManager.getExtension(ExtensionType.PRE_COMPILE, extensions, IPreCompileExtension.class);
    }

    private static <E> Set<E> getExtension(ExtensionType extensionType, Map<String, List<String>> availableExtensions, Class<E> clazz) {
        if (availableExtensions == null) {
            return Collections.emptySet();
        }
        Set<String> files = availableExtensions.keySet();
        LinkedHashSet<E> extensions = new LinkedHashSet<E>();
        for (String extensionPath : files) {
            List<String> parameters = availableExtensions.get(extensionPath);
            File extensionFile = new File(extensionPath);
            if (!extensionFile.exists()) {
                ThreadLocalToolkit.getLogger().log(new InvalidExtensionFileError(new FileNotFoundException().getLocalizedMessage()));
                continue;
            }
            try {
                Manifest mf;
                URLClassLoader loader;
                try {
                    loader = new URLClassLoader(new URL[]{extensionFile.toURL()}, Thread.currentThread().getContextClassLoader());
                    JarFile jar = new JarFile(extensionFile);
                    mf = jar.getManifest();
                }
                catch (IOException e) {
                    ThreadLocalToolkit.getLogger().log(new InvalidExtensionFileError(e.getLocalizedMessage()));
                    continue;
                }
                extensions.addAll(ExtensionManager.getClasses(mf, extensionType, loader, parameters, clazz));
            }
            catch (CompilerMessage.CompilerError e) {
                ThreadLocalToolkit.getLogger().log(e);
            }
        }
        return extensions;
    }

    private static <E> Set<E> getClasses(Manifest mf, ExtensionType extensionType, URLClassLoader loader, List<String> parameters, Class<E> clazz) throws CompilerMessage.CompilerError {
        String extensionsStr = mf.getMainAttributes().getValue(extensionType.getExtensionTag());
        if (extensionsStr == null) {
            return Collections.emptySet();
        }
        String[] extNames = extensionsStr.split(":");
        LinkedHashSet extensions = new LinkedHashSet();
        for (int j = 0; j < extNames.length; ++j) {
            Object extInstance;
            Class<?> extClass;
            String extName = extNames[j];
            try {
                extClass = loader.loadClass(extName);
            }
            catch (ClassNotFoundException e) {
                throw new UnexistentExtensionError(extName);
            }
            if (clazz.isAssignableFrom(extClass)) {
                try {
                    extInstance = extClass.newInstance();
                }
                catch (Exception e) {
                    throw new FailToInstanciateError(e.getMessage());
                }
                if (extInstance instanceof IConfigurableExtension) {
                    IConfigurableExtension configExtension = (IConfigurableExtension)extInstance;
                    configExtension.configure(parameters);
                }
            } else {
                throw new InvalidExtensionKindError(extClass, clazz);
            }
            extensions.add(extInstance);
        }
        return extensions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidExtensionKindError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3190757647243331631L;
        public Class<?> extensionClass;
        public Class<?> parentClass;

        public InvalidExtensionKindError(Class<?> extClass, Class<?> clazz) {
            this.extensionClass = extClass;
            this.parentClass = clazz;
        }
    }

    public static class UnexistentExtensionError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7778107370187386124L;
        public String extensionClassName;

        public UnexistentExtensionError(String extName) {
            this.extensionClassName = extName;
        }
    }

    public static class FailToInstanciateError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4329041275278609962L;
        public String errorMessage;

        public FailToInstanciateError(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class InvalidExtensionFileError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1466423208365841681L;
        public String errorMessage;

        public InvalidExtensionFileError(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtensionType {
        PRELINK("extensions-prelink"),
        MXMLC("extensions-mxmlc"),
        COMPC("extensions-compc"),
        APPLICATION("extensions-application"),
        LIBRARY("extensions-library"),
        PRE_COMPILE("extensions-pre-compile");

        private String extensionTag;

        private ExtensionType(String extensionTag) {
            this.extensionTag = extensionTag;
        }

        String getExtensionTag() {
            return this.extensionTag;
        }
    }
}

