/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.Info;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends Info {
    private String className;
    private List<QName> variables;
    private ClassInfo baseClassInfo;
    private String baseClassName;
    private MultiName baseClassMultiName;
    private Map<String, Boolean> skinParts;

    public ClassInfo(String className) {
        this.className = className;
        int lastIndex = className.lastIndexOf(":");
        if (lastIndex > 0) {
            this.addImport(className.substring(0, lastIndex));
        }
    }

    public void addVariable(QName variableName) {
        if (this.variables == null) {
            this.variables = new ArrayList<QName>();
        }
        this.variables.add(variableName);
    }

    public void addSkinPart(String fieldName, Boolean required) {
        if (this.skinParts == null) {
            this.skinParts = new HashMap<String, Boolean>();
        }
        this.skinParts.put(fieldName, required);
    }

    public boolean definesFunction(String functionName, boolean inherited) {
        boolean result = this.definesFunction(functionName);
        if (!result && inherited && this.baseClassInfo != null) {
            result = this.baseClassInfo.definesFunction(functionName, inherited);
        }
        return result;
    }

    public boolean definesGetter(String getterName, boolean inherited) {
        boolean result = super.definesGetter(getterName);
        if (!result && inherited && this.baseClassInfo != null) {
            result = this.baseClassInfo.definesGetter(getterName, inherited);
        }
        return result;
    }

    public boolean definesSetter(String setterName, boolean inherited) {
        boolean result = super.definesSetter(setterName);
        if (!result && inherited && this.baseClassInfo != null) {
            result = this.baseClassInfo.definesSetter(setterName, inherited);
        }
        return result;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassInfo getBaseClassInfo() {
        return this.baseClassInfo;
    }

    public String getBaseClassName() {
        return this.baseClassName;
    }

    public Map<String, Boolean> getSkinParts(Boolean inherited) {
        if (inherited.booleanValue()) {
            Map<String, Boolean> baseParts = null;
            if (this.baseClassInfo != null) {
                baseParts = this.baseClassInfo.getSkinParts(inherited);
            }
            HashMap<String, Boolean> inheritedMap = new HashMap<String, Boolean>();
            if (this.skinParts != null) {
                inheritedMap.putAll(this.skinParts);
            }
            if (baseParts != null) {
                inheritedMap.putAll(baseParts);
            }
            return inheritedMap;
        }
        return this.skinParts;
    }

    public MultiName getBaseClassMultiName() {
        if (this.baseClassMultiName == null) {
            this.baseClassMultiName = this.getMultiName(this.baseClassName);
        }
        return this.baseClassMultiName;
    }

    public boolean definesVariable(String variableName) {
        boolean result = false;
        if (this.variables != null) {
            for (QName qName : this.variables) {
                if (!variableName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        if (!result && this.baseClassInfo != null) {
            result = this.baseClassInfo.definesVariable(variableName);
        }
        return result;
    }

    public boolean extendsClass(String className) {
        boolean result = this.className.equals(className);
        if (!result && this.baseClassInfo != null) {
            result = this.baseClassInfo.extendsClass(className);
        }
        return result;
    }

    @Override
    public boolean implementsInterface(String namespace, String interfaceName) {
        boolean result = super.implementsInterface(namespace, interfaceName);
        if (!result && this.baseClassInfo != null) {
            result = this.baseClassInfo.implementsInterface(namespace, interfaceName);
        }
        return result;
    }

    public void setBaseClassInfo(ClassInfo baseClassInfo) {
        assert (baseClassInfo != null);
        if (baseClassInfo != this) {
            this.baseClassInfo = baseClassInfo;
        }
    }

    public void setBaseClassName(String baseClassName) {
        this.baseClassName = baseClassName;
    }
}

