/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import java.util.Iterator;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.CollectionUtils;
import org.apache.directory.api.util.Strings;

public final class AddRequestFactory
implements Messagefactory {
    public static final AddRequestFactory INSTANCE = new AddRequestFactory();

    private AddRequestFactory() {
    }

    private void encodeValueReverse(Asn1Buffer buffer, Iterator<Value> iterator) {
        iterator = CollectionUtils.reverse(iterator);
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])value.getBytes());
        }
    }

    private void encodeAttributeReverse(Asn1Buffer buffer, Iterator<Attribute> iterator) {
        iterator = CollectionUtils.reverse(iterator);
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            int start = buffer.getPos();
            if (attribute.size() == 0) {
                BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])Strings.EMPTY_BYTES);
            } else {
                this.encodeValueReverse(buffer, attribute.iterator());
            }
            BerValue.encodeSet((Asn1Buffer)buffer, (int)start);
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)attribute.getUpId());
            BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
        }
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        AddRequest addRequest = (AddRequest)message;
        Entry entry = addRequest.getEntry();
        if (entry.size() != 0) {
            this.encodeAttributeReverse(buffer, entry.iterator());
        }
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
        BerValue.encodeOctetString((Asn1Buffer)buffer, (String)entry.getDn().getName());
        BerValue.encodeSequence((Asn1Buffer)buffer, (byte)104, (int)start);
    }
}

