/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckNotNullLength<C extends Asn1Container>
extends GrammarAction<C> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckNotNullLength.class);

    public CheckNotNullLength() {
        super("Check that the length is not null");
    }

    @Override
    public void action(C container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_01101_NULL_LENGTH, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
    }
}

