/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.ParsedDnComparator;

public class UniqueMemberComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private transient SchemaManager schemaManager;
    private transient ParsedDnComparator dnComparator = new ParsedDnComparator("1.3.6.1.1.20");

    public UniqueMemberComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String dnstr1, String dnstr2) {
        Dn dn2;
        Dn dn1;
        int dash1 = dnstr1.lastIndexOf(35);
        int dash2 = dnstr2.lastIndexOf(35);
        if (dash1 == -1 && dash2 == -1) {
            try {
                Dn dn12 = this.getDn(dnstr1);
                Dn dn22 = this.getDn(dnstr2);
                return this.dnComparator.compare(dn12, dn22);
            }
            catch (LdapInvalidDnException ne) {
                return -1;
            }
        }
        if (dnstr1.indexOf(35) != dash1) {
            return -1;
        }
        if (dnstr2.indexOf(35) != dash1) {
            return 1;
        }
        String uid1 = dnstr1.substring(dash1 + 1);
        if (dash1 > 0) {
            try {
                dn1 = new Dn(dnstr1.substring(0, dash1));
            }
            catch (LdapException ne) {
                return -1;
            }
        } else {
            return -1;
        }
        String uid2 = dnstr2.substring(dash2 + 1);
        if (dash2 > 0) {
            try {
                dn2 = new Dn(dnstr1.substring(0, dash2));
            }
            catch (LdapException ne) {
                return 1;
            }
        } else {
            return 1;
        }
        int dnResult = this.dnComparator.compare(dn1, dn2);
        if (dnResult == 0) {
            return uid1.compareTo(uid2);
        }
        return dnResult;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public Dn getDn(Object obj) throws LdapInvalidDnException {
        Dn dn;
        if (obj instanceof Dn) {
            dn = (Dn)obj;
            dn = dn.isSchemaAware() ? dn : new Dn(this.schemaManager, dn);
        } else if (obj instanceof String) {
            dn = new Dn(this.schemaManager, (String)obj);
        } else {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_13720_CANNOT_HANDLE_DN_COMPARISONS, (Object[])new Object[]{obj == null ? null : obj.getClass()}));
        }
        return dn;
    }
}

