/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.core.impl.util.JndiUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jpa.api.config.base.JpaBaseConfig;
import org.apache.deltaspike.jpa.api.transaction.TransactionConfig;
import org.apache.deltaspike.jpa.impl.transaction.ResourceLocalTransactionStrategy;
import org.apache.deltaspike.jpa.impl.transaction.UserTransactionResolver;
import org.apache.deltaspike.jpa.impl.transaction.context.EntityManagerEntry;

@Dependent
@Alternative
public class BeanManagedUserTransactionStrategy
extends ResourceLocalTransactionStrategy {
    protected static final String TRANSACTION_SYNC_REGISTRY_JNDI_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final long serialVersionUID = -2432802805095533499L;
    private static final Logger LOGGER = Logger.getLogger(BeanManagedUserTransactionStrategy.class.getName());
    @Inject
    private BeanManager beanManager;
    private transient TransactionConfig transactionConfig;

    @Override
    protected EntityManagerEntry createEntityManagerEntry(EntityManager entityManager, Class<? extends Annotation> qualifier) {
        this.applyTransactionTimeout();
        return super.createEntityManagerEntry(entityManager, qualifier);
    }

    protected void applyTransactionTimeout() {
        Integer transactionTimeout = this.getDefaultTransactionTimeoutInSeconds();
        if (transactionTimeout == null) {
            return;
        }
        try {
            UserTransaction userTransaction = this.resolveUserTransaction();
            if (userTransaction != null && userTransaction.getStatus() != 0) {
                userTransaction.setTransactionTimeout(transactionTimeout.intValue());
            }
        }
        catch (SystemException e) {
            LOGGER.log(Level.WARNING, "UserTransaction#setTransactionTimeout failed", e);
        }
    }

    protected Integer getDefaultTransactionTimeoutInSeconds() {
        if (this.transactionConfig == null) {
            this.lazyInit();
        }
        return this.transactionConfig.getUserTransactionTimeoutInSeconds();
    }

    protected synchronized void lazyInit() {
        if (this.transactionConfig != null) {
            return;
        }
        this.transactionConfig = (TransactionConfig)BeanProvider.getContextualReference(TransactionConfig.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (this.transactionConfig == null) {
            this.transactionConfig = this.createDefaultTransactionConfig();
        }
    }

    protected TransactionConfig createDefaultTransactionConfig() {
        return new TransactionConfig(){
            private static final long serialVersionUID = -3915439087580270117L;

            public Integer getUserTransactionTimeoutInSeconds() {
                return JpaBaseConfig.UserTransaction.TIMEOUT_IN_SECONDS;
            }
        };
    }

    @Override
    protected EntityTransaction getTransaction(EntityManagerEntry entityManagerEntry) {
        return new UserTransactionAdapter();
    }

    @Override
    protected void beforeProceed(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
        entityManagerEntry.getEntityManager().joinTransaction();
    }

    protected UserTransaction resolveUserTransaction() {
        try {
            DependentProvider provider = BeanProvider.getDependent((BeanManager)this.beanManager, UserTransactionResolver.class, (Annotation[])new Annotation[0]);
            UserTransaction userTransaction = ((UserTransactionResolver)provider.get()).resolveUserTransaction();
            provider.destroy();
            return userTransaction;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected TransactionSynchronizationRegistry resolveTransactionRegistry() {
        return (TransactionSynchronizationRegistry)JndiUtils.lookup((String)TRANSACTION_SYNC_REGISTRY_JNDI_NAME, TransactionSynchronizationRegistry.class);
    }

    private class UserTransactionAdapter
    implements EntityTransaction {
        private final UserTransaction userTransaction;
        private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;

        public UserTransactionAdapter() {
            this.userTransaction = BeanManagedUserTransactionStrategy.this.resolveUserTransaction();
            if (this.userTransaction == null) {
                this.transactionSynchronizationRegistry = BeanManagedUserTransactionStrategy.this.resolveTransactionRegistry();
                if (this.transactionSynchronizationRegistry.getTransactionStatus() != 0) {
                    throw new IllegalStateException("The CMT is not active. Please check the config of the Data-Source.");
                }
            } else {
                this.transactionSynchronizationRegistry = null;
            }
        }

        public void begin() {
            if (this.userTransaction == null) {
                throw new UnsupportedOperationException("A CMT is active. This operation is only supported with BMT.");
            }
            try {
                if (this.userTransaction.getStatus() == 6) {
                    this.userTransaction.begin();
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public void commit() {
            if (this.userTransaction == null) {
                throw new UnsupportedOperationException("A CMT is active. This operation is only supported with BMT.");
            }
            try {
                if (this.isTransactionReadyToCommit()) {
                    this.userTransaction.commit();
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public void rollback() {
            if (this.userTransaction == null) {
                throw new UnsupportedOperationException("A CMT is active. This operation is only supported with BMT.");
            }
            try {
                if (this.isTransactionAllowedToRollback()) {
                    this.userTransaction.rollback();
                }
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public void setRollbackOnly() {
            try {
                if (this.userTransaction != null) {
                    this.userTransaction.setRollbackOnly();
                } else {
                    this.transactionSynchronizationRegistry.setRollbackOnly();
                }
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public boolean getRollbackOnly() {
            try {
                return this.getTransactionStatus() == 1;
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public boolean isActive() {
            try {
                return this.getTransactionStatus() != 6 && this.getTransactionStatus() != 5;
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        protected boolean isTransactionAllowedToRollback() throws SystemException {
            return this.getTransactionStatus() != 3 && this.getTransactionStatus() != 6 && this.getTransactionStatus() != 5;
        }

        protected boolean isTransactionReadyToCommit() throws SystemException {
            return this.getTransactionStatus() == 0 || this.getTransactionStatus() == 7 || this.getTransactionStatus() == 2;
        }

        protected int getTransactionStatus() throws SystemException {
            if (this.userTransaction != null) {
                return this.userTransaction.getStatus();
            }
            return this.transactionSynchronizationRegistry.getTransactionStatus();
        }
    }
}

