/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.postprocessor;

import javax.persistence.metamodel.SingularAttribute;
import org.apache.deltaspike.data.impl.builder.OrderDirection;
import org.apache.deltaspike.data.impl.handler.QueryStringPostProcessor;

public class OrderByQueryStringPostProcessor
implements QueryStringPostProcessor {
    private static final String ORDER_BY = " order by ";
    private final String attribute;
    private OrderDirection direction;
    private boolean appendEntityName;

    public OrderByQueryStringPostProcessor(SingularAttribute<?, ?> attribute, OrderDirection direction, boolean appendEntityName) {
        this.attribute = attribute.getName();
        this.direction = direction;
        this.appendEntityName = appendEntityName;
    }

    public OrderByQueryStringPostProcessor(String attribute, OrderDirection direction, boolean appendEntityName) {
        this.attribute = attribute;
        this.direction = direction;
        this.appendEntityName = appendEntityName;
    }

    @Override
    public String postProcess(String queryString) {
        StringBuilder builder = new StringBuilder(queryString);
        if (queryString.contains(ORDER_BY)) {
            builder.append(",");
        } else {
            builder.append(ORDER_BY);
        }
        if (this.appendEntityName) {
            builder.append("e").append(".");
        }
        return builder.append(this.attribute).append(" ").append((Object)this.direction).toString();
    }

    public boolean matches(SingularAttribute<?, ?> attribute) {
        return this.matches(attribute.getName());
    }

    public boolean matches(String attribute) {
        return this.attribute.equals(attribute);
    }

    public void changeDirection() {
        this.direction = this.direction.change();
    }
}

