/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util.metadata.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.core.util.metadata.builder.AnnotationStore;

class AnnotationBuilder {
    private final Map<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Annotation> annotationSet = new HashSet<Annotation>();

    AnnotationBuilder() {
    }

    public AnnotationBuilder add(Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("annotation parameter must not be null");
        }
        this.annotationSet.add(annotation);
        this.annotationMap.put(annotation.annotationType(), annotation);
        return this;
    }

    public AnnotationBuilder remove(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("annotationType parameter must not be null");
        }
        Iterator<Annotation> it = this.annotationSet.iterator();
        while (it.hasNext()) {
            Annotation an = it.next();
            if (!annotationType.isAssignableFrom(an.annotationType())) continue;
            it.remove();
        }
        this.annotationMap.remove(annotationType);
        return this;
    }

    public AnnotationStore create() {
        return new AnnotationStore(this.annotationMap, this.annotationSet);
    }

    public AnnotationBuilder addAll(Collection<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            this.add(annotation);
        }
        return this;
    }

    public AnnotationBuilder addAll(AnnotationStore annotations) {
        for (Annotation annotation : annotations.getAnnotations()) {
            this.add(annotation);
        }
        return this;
    }

    public AnnotationBuilder addAll(AnnotatedElement element) {
        for (Annotation a : element.getAnnotations()) {
            this.add(a);
        }
        return this;
    }

    public <T extends Annotation> T getAnnotation(Class<T> anType) {
        return (T)this.annotationMap.get(anType);
    }

    public boolean isAnnotationPresent(Class<?> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    public String toString() {
        return this.annotationSet.toString();
    }
}

